/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.json.JsonNodeStringBuilder;
import org.citrusframework.json.JsonStringBuilder;
import org.citrusframework.yaml.YamlNodeStringBuilder;
import org.citrusframework.yaml.YamlStringBuilder;

public final class TestResult {
    private final RESULT result;
    private final String testName;
    private final String className;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    @Nullable
    private Throwable cause;
    @Nullable
    private String errorMessage;
    @Nullable
    private String failureStack;
    @Nullable
    private String failureType;
    @Nullable
    private Duration duration;

    public static TestResult success(String name, String className) {
        return new TestResult(RESULT.SUCCESS, name, className);
    }

    public static TestResult success(String name, String className, Map<String, Object> parameters) {
        return new TestResult(RESULT.SUCCESS, name, className).withParameters(parameters);
    }

    public static TestResult skipped(String name, String className) {
        return new TestResult(RESULT.SKIP, name, className);
    }

    public static TestResult skipped(String name, String className, @Nonnull Map<String, Object> parameters) {
        return new TestResult(RESULT.SKIP, name, className).withParameters(parameters);
    }

    public static TestResult failed(String name, String className, @Nullable Throwable cause) {
        return new TestResult(RESULT.FAILURE, name, className).withCause(cause).withErrorMessage(Optional.ofNullable(cause).map(Throwable::getMessage).orElse(""));
    }

    public static TestResult failed(String name, String className, @Nonnull String errorMessage) {
        return new TestResult(RESULT.FAILURE, name, className).withErrorMessage(errorMessage);
    }

    public static TestResult failed(String name, String className, @Nullable Throwable cause, @Nonnull Map<String, Object> parameters) {
        return new TestResult(RESULT.FAILURE, name, className).withParameters(parameters).withCause(cause).withErrorMessage(Optional.ofNullable(cause).map(Throwable::getMessage).orElse(""));
    }

    TestResult(RESULT result, String testName, String className) {
        this.result = result;
        this.testName = testName;
        this.className = className;
    }

    public boolean isSuccess() {
        return RESULT.SUCCESS.equals((Object)this.result);
    }

    public boolean isFailed() {
        return RESULT.FAILURE.equals((Object)this.result);
    }

    public boolean isSkipped() {
        return RESULT.SKIP.equals((Object)this.result);
    }

    public String getResult() {
        return this.result.name();
    }

    public String getTestName() {
        return this.testName;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Nullable
    public Throwable getCause() {
        return this.cause;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public String getFailureStack() {
        return this.failureStack;
    }

    @Nullable
    public String getFailureType() {
        return this.failureType;
    }

    public TestResult withFailureType(String failureType) {
        this.failureType = failureType;
        return this;
    }

    @Nullable
    public Duration getDuration() {
        return this.duration;
    }

    public TestResult withDuration(Duration duration) {
        this.duration = duration;
        return this;
    }

    private TestResult withParameters(Map<String, Object> parameters) {
        this.parameters.putAll(parameters);
        return this;
    }

    private TestResult withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    private TestResult withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getClass().getSimpleName()).append("[").append("testName=").append(this.testName);
        if (this.className != null) {
            builder.append(", className=").append(this.className);
        }
        if (!this.parameters.isEmpty()) {
            builder.append(", parameters=[").append(this.parameters.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(", "))).append("]");
        }
        builder.append(", result=").append((Object)this.result);
        if (this.cause != null) {
            builder.append(", cause=").append(this.cause);
        }
        if (this.errorMessage != null) {
            builder.append(", errorMessage=").append(this.errorMessage);
        }
        if (this.failureStack != null) {
            builder.append(", failureStack=").append(this.failureStack);
        }
        if (this.failureType != null) {
            builder.append(", failureType=").append(this.failureType);
        }
        if (Objects.nonNull(this.duration)) {
            builder.append(", duration=").append(this.duration.toMillis()).append("ms");
        }
        return builder.append("]").toString();
    }

    public String toJson() {
        JsonNodeStringBuilder builder = new JsonStringBuilder().withObject().withProperty("name", this.testName);
        if (this.className != null) {
            builder.withProperty("className", this.className);
        }
        if (!this.parameters.isEmpty()) {
            builder.withProperty("parameters").withArray(this.parameters);
        }
        builder.withProperty("result", this.result.name());
        if (this.cause != null) {
            builder.withPropertyEscaped("cause", this.cause.toString());
        }
        if (this.errorMessage != null) {
            builder.withPropertyEscaped("errorMessage", this.errorMessage);
        }
        if (this.failureStack != null) {
            builder.withProperty("failureStack", this.failureStack);
        }
        if (this.failureType != null) {
            builder.withProperty("failureType", this.failureType);
        }
        if (Objects.nonNull(this.duration)) {
            builder.withProperty("duration", this.duration.toMillis());
        }
        return builder.closeObject().toString();
    }

    public String toYaml() {
        YamlNodeStringBuilder builder = new YamlStringBuilder().withProperty("name", this.testName);
        if (this.className != null) {
            builder.withProperty("className", this.className);
        }
        if (!this.parameters.isEmpty()) {
            builder.withObject("parameters").withProperties(this.parameters).closeObject();
        }
        builder.withProperty("result", this.result.name());
        if (this.cause != null) {
            builder.withPropertyBlockStyle("cause", this.cause.toString());
        }
        if (this.errorMessage != null) {
            builder.withPropertyBlockStyle("errorMessage", this.errorMessage);
        }
        if (this.failureStack != null) {
            builder.withProperty("failureStack", this.failureStack);
        }
        if (this.failureType != null) {
            builder.withProperty("failureType", this.failureType);
        }
        if (Objects.nonNull(this.duration)) {
            builder.withProperty("duration", this.duration.toMillis());
        }
        return builder.toString();
    }

    public static enum RESULT {
        SUCCESS,
        FAILURE,
        SKIP;

    }
}

