/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.citrusframework.annotations.CitrusEndpoint;
import org.citrusframework.annotations.CitrusEndpointProperty;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.TypeConversionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EndpointBuilder<T extends Endpoint> {
    public static final Logger logger = LoggerFactory.getLogger(EndpointBuilder.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/endpoint/builder";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/endpoint/builder");

    public boolean supports(Class<?> var1);

    public T build();

    default public T build(CitrusEndpoint endpointAnnotation, ReferenceResolver referenceResolver) {
        Method nameSetter = ReflectionHelper.findMethod(this.getClass(), "name", String.class);
        if (nameSetter != null) {
            ReflectionHelper.invokeMethod(nameSetter, this, endpointAnnotation.name());
        }
        for (CitrusEndpointProperty endpointProperty : endpointAnnotation.properties()) {
            Method propertyMethod = ReflectionHelper.findMethod(this.getClass(), endpointProperty.name(), endpointProperty.type());
            if (propertyMethod == null) continue;
            if (!endpointProperty.type().equals(String.class) && referenceResolver.isResolvable(endpointProperty.value())) {
                ReflectionHelper.invokeMethod(propertyMethod, this, referenceResolver.resolve(endpointProperty.value(), endpointProperty.type()));
                continue;
            }
            ReflectionHelper.invokeMethod(propertyMethod, this, TypeConversionUtils.convertStringToType(endpointProperty.value(), endpointProperty.type()));
        }
        return this.build();
    }

    default public T build(Properties endpointProperties, ReferenceResolver referenceResolver) {
        for (Map.Entry<Object, Object> endpointProperty : endpointProperties.entrySet()) {
            Method propertyMethod = ReflectionHelper.findMethod(this.getClass(), endpointProperty.getKey().toString(), endpointProperty.getValue().getClass());
            if (propertyMethod == null) continue;
            ReflectionHelper.invokeMethod(propertyMethod, this, endpointProperty.getValue());
        }
        return this.build();
    }

    public static Map<String, EndpointBuilder<?>> lookup() {
        HashMap builders = new HashMap(TYPE_RESOLVER.resolveAll("", "*").entrySet().stream().collect(Collectors.toMap(entry -> {
            if (((String)entry.getKey()).endsWith(".type")) {
                return ((String)entry.getKey()).substring(0, ((String)entry.getKey()).lastIndexOf(".type"));
            }
            return (String)entry.getKey();
        }, entry -> (EndpointBuilder)entry.getValue())));
        if (logger.isDebugEnabled()) {
            builders.forEach((k, v) -> logger.debug("Found endpoint builder '{}' as {}", k, v.getClass()));
        }
        return builders;
    }

    public static Optional<EndpointBuilder<?>> lookup(String builder) {
        try {
            EndpointBuilder instance;
            if (builder.contains(".")) {
                int separatorIndex = builder.lastIndexOf(46);
                instance = (EndpointBuilder)TYPE_RESOLVER.resolve(builder.substring(0, separatorIndex), builder.substring(separatorIndex + 1), new Object[0]);
            } else {
                instance = (EndpointBuilder)TYPE_RESOLVER.resolve(builder, new Object[0]);
            }
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve endpoint builder from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)builder);
            return Optional.empty();
        }
    }
}

