/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.TypeConverter;

public abstract class TypeConversionUtils {
    private static TypeConverter typeConverter = TypeConverter.lookupDefault();

    private TypeConversionUtils() {
    }

    public static void loadDefaultConverter() {
        typeConverter = TypeConverter.lookupDefault();
    }

    public static <T> T convertIfNecessary(Object target, Class<T> type) {
        return typeConverter.convertIfNecessary(target, type);
    }

    public static <T> T convertStringToType(String value, Class<T> type) {
        return typeConverter.convertStringToType(value, type);
    }

    public static <T> T convertStringToType(String value, Class<T> type, TestContext context) {
        try {
            return TypeConversionUtils.convertStringToType(value, type);
        }
        catch (CitrusRuntimeException e) {
            T bean;
            if (context.getReferenceResolver() != null && context.getReferenceResolver().isResolvable(value) && type.isAssignableFrom((bean = context.getReferenceResolver().resolve(value, type)).getClass())) {
                return bean;
            }
            throw new CitrusRuntimeException(String.format("Unable to convert '%s' to required type '%s' - also no bean of required type available in application context", value, type.getName()), e.getCause());
        }
    }
}

