/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.message.Message;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.citrusframework.spi.TypeResolver;
import org.citrusframework.validation.context.ValidationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MessageValidator<T extends ValidationContext> {
    public static final Logger logger = LoggerFactory.getLogger(MessageValidator.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/message/validator";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/message/validator");

    public static Map<String, MessageValidator<? extends ValidationContext>> lookup() {
        Map<String, MessageValidator<? extends ValidationContext>> validators = TYPE_RESOLVER.resolveAll("", "type", "name");
        if (logger.isDebugEnabled()) {
            validators.forEach((k, v) -> logger.debug("Found message validator '{}' as {}", k, v.getClass()));
        }
        return validators;
    }

    public static Optional<MessageValidator<? extends ValidationContext>> lookup(String validator) {
        try {
            MessageValidator instance = (MessageValidator)TYPE_RESOLVER.resolve(validator, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve validator from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)validator);
            return Optional.empty();
        }
    }

    public void validateMessage(Message var1, Message var2, TestContext var3, List<ValidationContext> var4) throws ValidationException;

    public boolean supportsMessageType(String var1, Message var2);
}

