/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions.testcontainers.aws2;

import java.util.Arrays;
import org.citrusframework.exceptions.CitrusRuntimeException;

public enum AwsService {
    CLOUD_WATCH("cloudwatch"),
    DYNAMODB("dynamodb"),
    EC2("ec2"),
    EVENT_BRIDGE("eventbridge"),
    IAM("iam"),
    KINESIS("kinesis"),
    KMS("kms"),
    LAMBDA("lambda"),
    S3("s3"),
    SECRETS_MANAGER("secretsmanager"),
    SNS("sns"),
    SQS("sqs"),
    STS("sts");

    private final String serviceName;

    private AwsService(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public static String serviceName(AwsService service) {
        return service.serviceName;
    }

    public static AwsService fromServiceName(String serviceName) {
        return Arrays.stream(AwsService.values()).filter(service -> service.serviceName.equals(serviceName)).findFirst().orElseThrow(() -> new CitrusRuntimeException("Unknown AWS LocalStack service name: %s".formatted(serviceName)));
    }
}

