/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.main;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.TestSource;
import org.citrusframework.spi.Resources;
import org.citrusframework.yaml.SchemaProperty;

public class TestRunConfiguration {
    private String engine = "junit5";
    private final List<TestSource> sources = new ArrayList<TestSource>();
    private final List<String> packages = new ArrayList<String>();
    private String[] includes = new String[]{"^.*IT$", "^.*ITCase$", "^IT.*$"};
    private Map<String, String> defaultProperties = new LinkedHashMap<String, String>();
    private File testJar;
    private String workDir;
    private boolean verbose = true;
    private boolean reset = true;

    public String getEngine() {
        return this.engine;
    }

    @SchemaProperty(required=true, description="The test engine to use when running tests", defaultValue="junit5")
    public void setEngine(String engine) {
        this.engine = engine;
    }

    public List<TestSource> getTestSources() {
        return this.sources;
    }

    @SchemaProperty(description="List of test sources to run. A test source represents a source code file in one of the supported languages (.java, .xml, .groovy, .yaml, .feature)")
    public void setTestSources(List<TestSource> sources) {
        this.sources.addAll(sources);
    }

    public List<String> getPackages() {
        return this.packages;
    }

    @SchemaProperty(description="List of package names to search for tests. All tests found in these packages are executed.")
    public void setPackages(List<String> packages) {
        this.packages.addAll(packages);
    }

    public String[] getIncludes() {
        return this.includes;
    }

    @SchemaProperty(description="Test name patterns that specify which tests to include in the test run. Used when scanning packages for tests.")
    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public File getTestJar() {
        return this.testJar;
    }

    public void setTestJar(File testJar) {
        this.testJar = testJar;
    }

    @SchemaProperty(description="Set the test jar holding tests to execute. Jar file is used to perform package scans for test cases to run.")
    public void setTestJar(String testJar) {
        if (testJar != null) {
            this.testJar = Resources.create(testJar).getFile();
        }
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    @SchemaProperty(description="Sets default properties")
    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void addDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties.putAll(defaultProperties);
    }

    public boolean hasTests() {
        return !this.getTestSources().isEmpty() || !this.getPackages().isEmpty() || this.getTestJar() != null;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @SchemaProperty(description="When enabled the test run prints verbose messages.", defaultValue="true")
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isReset() {
        return this.reset;
    }

    @SchemaProperty(description="When enabled the Citrus context instance is reset after the test.", defaultValue="true")
    public void setReset(boolean reset) {
        this.reset = reset;
    }

    @SchemaProperty(description="Set custom working directory. File system based test engines may use this directory to read files from.")
    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }
}

