/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaml;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface YamlNodeStringBuilder {
    public StringBuilder getBuilder();

    public YamlNodeStringBuilder applyIndent();

    public YamlNodeStringBuilder append(String var1);

    default public YamlNodeStringBuilder append(List<String> items) {
        items.forEach(this::append);
        return this;
    }

    public YamlNodeStringBuilder withObject(String var1);

    public YamlNodeStringBuilder closeObject();

    default public YamlNodeStringBuilder withProperty(String name, String value) {
        this.applyIndent();
        if (value.contains("\"")) {
            this.getBuilder().append(name).append(": |\n");
            this.applyIndent();
            this.getBuilder().append("  ").append(value).append("\n");
        } else {
            this.getBuilder().append(name).append(": \"").append(value).append("\"\n");
        }
        return this;
    }

    default public YamlNodeStringBuilder withProperty(String name, long value) {
        this.applyIndent();
        this.getBuilder().append(name).append(": ").append(value).append("\n");
        return this;
    }

    default public YamlNodeStringBuilder withPropertyBlockStyle(String name, String value) {
        this.applyIndent();
        this.getBuilder().append(name).append(": |\n");
        this.applyIndent();
        this.getBuilder().append("  ").append(value).append("\n");
        return this;
    }

    default public YamlNodeStringBuilder withProperties(Map<String, Object> items) {
        items.forEach((key, value) -> {
            this.withProperty("name", (String)key);
            this.withProperty("value", String.valueOf(value));
        });
        return this;
    }

    default public YamlNodeStringBuilder withArray(String name, List<String> items) {
        this.applyIndent();
        if (items.isEmpty()) {
            this.getBuilder().append(name).append(": []\n");
        } else {
            this.getBuilder().append(name).append(": ").append("[ %s ]".formatted(items.stream().map(arg_0 -> YamlNodeStringBuilder.lambda$withArray$1("'%s'", arg_0)).collect(Collectors.joining(",")))).append("\n");
        }
        return this;
    }

    public YamlNodeStringBuilder withArray();

    public YamlNodeStringBuilder closeArray();

    private static /* synthetic */ String lambda$withArray$1(String rec$, Object xva$0) {
        return "'%s'".formatted(xva$0);
    }
}

