/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntRunAction
extends AbstractTestAction {
    private final String buildFilePath;
    private final String target;
    private final String targets;
    private final Properties properties;
    private final String propertyFilePath;
    private final BuildListener buildListener;
    private static final Logger logger = LoggerFactory.getLogger(AntRunAction.class);

    private AntRunAction(Builder builder) {
        super("antrun", builder);
        this.buildFilePath = builder.buildFilePath;
        this.target = builder.target;
        this.targets = builder.targets;
        this.properties = builder.properties;
        this.propertyFilePath = builder.propertyFilePath;
        this.buildListener = builder.buildListener;
    }

    @Override
    public void doExecute(TestContext context) {
        Project project = new Project();
        project.init();
        String buildFileResource = context.replaceDynamicContentInString(this.buildFilePath);
        try {
            ProjectHelper.configureProject((Project)project, (File)Resources.fromClasspath((String)buildFileResource).getFile());
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String propertyValue = entry.getValue() != null ? context.replaceDynamicContentInString(entry.getValue().toString()) : "";
                logger.debug("Set build property: " + entry.getKey() + "=" + propertyValue);
                project.setProperty(entry.getKey().toString(), propertyValue);
            }
            this.loadBuildPropertyFile(project, context);
            if (this.buildListener != null) {
                project.addBuildListener(this.buildListener);
            }
            DefaultLogger consoleLogger = AntRunAction.getDefaultConsoleLogger();
            project.addBuildListener((BuildListener)consoleLogger);
            logger.info("Executing ANT build: " + buildFileResource);
            if (StringUtils.hasText(this.targets)) {
                logger.info("Executing ANT targets: " + this.targets);
                project.executeTargets(this.parseTargets());
            } else {
                logger.info("Executing ANT target: " + this.target);
                project.executeTarget(this.target);
            }
        }
        catch (BuildException e) {
            throw new CitrusRuntimeException("Failed to run ANT build file", (Throwable)e);
        }
        logger.info("Executed ANT build: " + buildFileResource);
    }

    private static DefaultLogger getDefaultConsoleLogger() {
        DefaultLogger consoleLogger = new DefaultLogger(){

            protected void printMessage(String message, PrintStream stream, int priority) {
                if (stream.equals(System.err)) {
                    logger.error(message);
                } else {
                    logger.info(message);
                }
            }
        };
        consoleLogger.setErrorPrintStream(System.err);
        consoleLogger.setOutputPrintStream(System.out);
        consoleLogger.setMessageOutputLevel(4);
        return consoleLogger;
    }

    private Stack<String> parseTargets() {
        String[] targetTokens;
        Stack<String> stack = new Stack<String>();
        for (String targetToken : targetTokens = this.targets.split(",")) {
            stack.add(targetToken.trim());
        }
        return stack;
    }

    private void loadBuildPropertyFile(Project project, TestContext context) {
        if (StringUtils.hasText(this.propertyFilePath)) {
            String propertyFileResource = context.replaceDynamicContentInString(this.propertyFilePath);
            logger.info("Reading build property file: " + propertyFileResource);
            Properties fileProperties = new Properties();
            try {
                Resource propertyResource = Resources.fromClasspath((String)propertyFileResource);
                fileProperties.load(propertyResource.getInputStream());
                for (Map.Entry<Object, Object> entry : fileProperties.entrySet()) {
                    String propertyValue;
                    String string = propertyValue = entry.getValue() != null ? context.replaceDynamicContentInString(entry.getValue().toString()) : "";
                    if (logger.isDebugEnabled()) {
                        logger.debug("Set build property from file resource: " + entry.getKey() + "=" + propertyValue);
                    }
                    project.setProperty(entry.getKey().toString(), propertyValue);
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read build property file", (Throwable)e);
            }
        }
    }

    public String getBuildFilePath() {
        return this.buildFilePath;
    }

    public String getTarget() {
        return this.target;
    }

    public String getTargets() {
        return this.targets;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertyFilePath() {
        return this.propertyFilePath;
    }

    public BuildListener getBuildListener() {
        return this.buildListener;
    }

    public static final class Builder
    extends AbstractTestActionBuilder<AntRunAction, Builder>
    implements ReferenceResolverAware {
        private String buildFilePath;
        private String target;
        private String targets;
        private final Properties properties = new Properties();
        private String propertyFilePath;
        private BuildListener buildListener;
        private String buildListenerName;
        private ReferenceResolver referenceResolver;

        public static Builder antrun() {
            return new Builder();
        }

        public static Builder antrun(String buildFilePath) {
            Builder builder = new Builder();
            builder.buildFilePath(buildFilePath);
            return builder;
        }

        public Builder buildFilePath(String buildFilePath) {
            this.buildFilePath = buildFilePath;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder targets(String ... targets) {
            this.targets = String.join((CharSequence)",", targets);
            return this;
        }

        public Builder property(String name, Object value) {
            this.properties.put(name, value);
            return this;
        }

        public Builder properties(Properties properties) {
            this.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder propertyFile(String filePath) {
            this.propertyFilePath = filePath;
            return this;
        }

        public Builder listener(BuildListener buildListener) {
            this.buildListener = buildListener;
            return this;
        }

        public Builder listenerName(String buildListener) {
            this.buildListenerName = buildListener;
            return this;
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }

        public AntRunAction build() {
            if (this.buildListenerName != null && this.referenceResolver != null) {
                this.listener((BuildListener)this.referenceResolver.resolve(this.buildListenerName, BuildListener.class));
            }
            return new AntRunAction(this);
        }
    }
}

