/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractIteratingContainerBuilder;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.container.IteratingConditionExpression;
import org.citrusframework.context.TestContext;
import org.citrusframework.context.TestContextFactory;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.BooleanExpressionParser;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;

public abstract class AbstractIteratingActionContainer
extends AbstractActionContainer {
    protected final String condition;
    protected final IteratingConditionExpression conditionExpression;
    protected final String indexName;
    protected final int start;
    protected int index;

    public AbstractIteratingActionContainer(String name, AbstractIteratingContainerBuilder<?, ?> builder) {
        super(name, (AbstractTestContainerBuilder<?, ?>)builder);
        this.condition = builder.getCondition();
        this.conditionExpression = builder.getConditionExpression();
        this.indexName = builder.getIndexName();
        this.index = builder.getIndex();
        this.start = builder.getStart();
    }

    @Override
    public final void doExecute(TestContext context) {
        this.index = this.start;
        this.executeIteration(context);
    }

    protected abstract void executeIteration(TestContext var1);

    protected void executeActions(TestContext context) {
        context.setVariable(this.indexName, (Object)String.valueOf(this.index));
        for (TestActionBuilder actionBuilder : this.actions) {
            this.executeAction(actionBuilder.build(), context);
        }
    }

    protected boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(this.index, context);
        }
        String conditionString = this.condition;
        TestContext temp = TestContextFactory.copyOf(context);
        temp.setVariable(this.indexName, (Object)String.valueOf(this.index));
        conditionString = temp.replaceDynamicContentInString(conditionString);
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)conditionString)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)"iteratingCondition", (String)String.valueOf(this.index), (String)conditionString, (TestContext)context);
                return true;
            }
            catch (AssertionError | ValidationException e) {
                return false;
            }
        }
        if (conditionString.contains(this.indexName)) {
            conditionString = conditionString.replaceAll(this.indexName, String.valueOf(this.index));
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public String getCondition() {
        return this.condition;
    }

    public IteratingConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getStart() {
        return this.start;
    }
}

