/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ParallelContainerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parallel
extends AbstractActionContainer {
    private final Stack<Thread> threads = new Stack();
    private final List<CitrusRuntimeException> exceptions = new ArrayList<CitrusRuntimeException>();
    private static final Logger logger = LoggerFactory.getLogger(Parallel.class);

    public Parallel(Builder builder) {
        super("parallel", builder);
    }

    @Override
    public void doExecute(TestContext context) {
        for (TestActionBuilder actionBuilder : this.actions) {
            TestAction action = actionBuilder.build();
            Thread t = new Thread(new ActionRunner(ctx -> this.executeAction(action, ctx), context, this.exceptions::add));
            this.threads.push(t);
            t.start();
        }
        while (!this.threads.isEmpty()) {
            try {
                this.threads.pop().join();
            }
            catch (InterruptedException e) {
                logger.error("Unable to join thread", (Throwable)e);
            }
        }
        if (!this.exceptions.isEmpty()) {
            if (this.exceptions.size() == 1) {
                throw this.exceptions.get(0);
            }
            throw new ParallelContainerException(this.exceptions);
        }
    }

    private static class ActionRunner
    implements Runnable {
        private final TestAction action;
        private final TestContext context;
        private final Consumer<CitrusRuntimeException> exceptionHandler;

        public ActionRunner(TestAction action, TestContext context, Consumer<CitrusRuntimeException> exceptionHandler) {
            this.action = action;
            this.context = context;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void run() {
            try {
                this.action.execute(this.context);
            }
            catch (CitrusRuntimeException e) {
                logger.error("Parallel test action raised error", (Throwable)e);
                this.exceptionHandler.accept(e);
            }
            catch (AssertionError | Exception e) {
                logger.error("Parallel test action raised error", (Throwable)e);
                this.exceptionHandler.accept(new CitrusRuntimeException((Throwable)e));
            }
        }
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Parallel, Builder> {
        public static Builder parallel() {
            return new Builder();
        }

        @Override
        public Parallel doBuild() {
            return new Parallel(this);
        }
    }
}

