/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import org.citrusframework.TestActor;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public abstract class AbstractEndpointBuilder<T extends Endpoint>
implements EndpointBuilder<T> {
    public AbstractEndpointBuilder<T> name(String endpointName) {
        this.getEndpoint().setName(endpointName);
        return this;
    }

    public AbstractEndpointBuilder<T> actor(TestActor actor) {
        this.getEndpoint().setActor(actor);
        return this;
    }

    public AbstractEndpointBuilder<T> initialize() {
        if (this.getEndpoint() instanceof InitializingPhase) {
            try {
                ((InitializingPhase)this.getEndpoint()).initialize();
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Failed to initialize server", (Throwable)e);
            }
        }
        return this;
    }

    public AbstractEndpointBuilder<T> referenceResolver(ReferenceResolver referenceResolver) {
        if (this.getEndpoint() instanceof ReferenceResolverAware) {
            ((ReferenceResolverAware)this.getEndpoint()).setReferenceResolver(referenceResolver);
        }
        return this;
    }

    public T build() {
        return this.getEndpoint();
    }

    public boolean supports(Class<?> endpointType) {
        return this.getEndpoint().getClass().equals(endpointType);
    }

    protected abstract T getEndpoint();
}

