/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointComponent;
import org.citrusframework.endpoint.EndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.StringUtils;
import org.citrusframework.util.TypeConversionUtils;

public abstract class AbstractEndpointComponent
implements EndpointComponent {
    private final String name;

    public AbstractEndpointComponent(String name) {
        this.name = name;
    }

    public Endpoint createEndpoint(String endpointUri, TestContext context) {
        try {
            Endpoint endpoint;
            URI uri = new URI(endpointUri);
            String path = uri.getSchemeSpecificPart();
            if (path.startsWith("//")) {
                path = path.substring(2);
            }
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf(63));
            }
            Map<String, String> parameters = this.getParameters(endpointUri);
            String endpointName = null;
            if (parameters.containsKey("endpointName")) {
                endpointName = parameters.remove("endpointName");
            }
            if ((endpoint = this.createEndpoint(path, parameters, context)) instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)endpoint).setReferenceResolver(context.getReferenceResolver());
            }
            if (StringUtils.hasText(endpointName)) {
                endpoint.setName(endpointName);
            }
            return endpoint;
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException(String.format("Unable to parse endpoint uri '%s'", endpointUri), (Throwable)e);
        }
    }

    public Map<String, String> getParameters(String endpointUri) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (endpointUri.contains("?")) {
            String parameterString = endpointUri.substring(endpointUri.indexOf(63) + 1);
            StringTokenizer tok = new StringTokenizer(parameterString, "&");
            while (tok.hasMoreElements()) {
                Object[] parameterValue = tok.nextToken().split("=");
                if (parameterValue.length == 1) {
                    parameters.put(parameterValue[0], null);
                    continue;
                }
                if (parameterValue.length == 2) {
                    parameters.put(parameterValue[0], parameterValue[1]);
                    continue;
                }
                throw new CitrusRuntimeException(String.format("Invalid parameter key/value combination '%s'", Arrays.toString(parameterValue)));
            }
        }
        return parameters;
    }

    protected void enrichEndpointConfiguration(EndpointConfiguration endpointConfiguration, Map<String, String> parameters, TestContext context) {
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionHelper.findField(endpointConfiguration.getClass(), (String)parameterEntry.getKey());
            if (field == null) {
                throw new CitrusRuntimeException(String.format("Unable to find parameter field on endpoint configuration '%s'", parameterEntry.getKey()));
            }
            Method setter = ReflectionHelper.findMethod(endpointConfiguration.getClass(), (String)("set" + parameterEntry.getKey().substring(0, 1).toUpperCase() + parameterEntry.getKey().substring(1)), (Class[])new Class[]{field.getType()});
            if (setter == null) {
                throw new CitrusRuntimeException(String.format("Unable to find parameter setter on endpoint configuration '%s'", "set" + parameterEntry.getKey().substring(0, 1).toUpperCase() + parameterEntry.getKey().substring(1)));
            }
            if (parameterEntry.getValue() != null) {
                ReflectionHelper.invokeMethod((Method)setter, (Object)endpointConfiguration, (Object[])new Object[]{TypeConversionUtils.convertStringToType((String)parameterEntry.getValue(), field.getType(), (TestContext)context)});
                continue;
            }
            ReflectionHelper.invokeMethod((Method)setter, (Object)endpointConfiguration, (Object[])new Object[]{field.getType().cast(null)});
        }
    }

    protected Map<String, String> getEndpointConfigurationParameters(Map<String, String> parameters, Class<? extends EndpointConfiguration> endpointConfigurationType) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionHelper.findField(endpointConfigurationType, (String)parameterEntry.getKey());
            if (field == null) continue;
            params.put(parameterEntry.getKey(), parameterEntry.getValue());
        }
        return params;
    }

    protected String getParameterString(Map<String, String> parameters, Class<? extends EndpointConfiguration> endpointConfigurationType) {
        StringBuilder paramString = new StringBuilder();
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            Field field = ReflectionHelper.findField(endpointConfigurationType, (String)parameterEntry.getKey());
            if (field != null) continue;
            if (paramString.length() == 0) {
                paramString.append("?").append(parameterEntry.getKey());
                if (parameterEntry.getValue() == null) continue;
                paramString.append("=").append(parameterEntry.getValue());
                continue;
            }
            paramString.append("&").append(parameterEntry.getKey());
            if (parameterEntry.getValue() == null) continue;
            paramString.append("=").append(parameterEntry.getValue());
        }
        return paramString.toString();
    }

    protected abstract Endpoint createEndpoint(String var1, Map<String, String> var2, TestContext var3);

    public String getName() {
        return this.name;
    }
}

