/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.adapter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.CitrusSettings;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.adapter.StaticEndpointAdapter;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.message.Message;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public class StaticResponseEndpointAdapter
extends StaticEndpointAdapter {
    private String messagePayload = "";
    private String messagePayloadResource;
    private String messagePayloadResourceCharset = CitrusSettings.CITRUS_FILE_ENCODING;
    private Map<String, Object> messageHeader = new HashMap<String, Object>();

    @Override
    public Message handleMessageInternal(Message request) {
        String payload;
        TestContext context = this.getTestContext();
        context.getMessageStore().storeMessage("request", request);
        if (StringUtils.hasText(this.messagePayloadResource)) {
            try {
                payload = context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(this.messagePayloadResource), Charset.forName(context.replaceDynamicContentInString(this.messagePayloadResourceCharset))));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read message payload file resource", (Throwable)e);
            }
        } else {
            payload = context.replaceDynamicContentInString(this.messagePayload);
        }
        return new DefaultMessage(payload, context.resolveDynamicValuesInMap(this.messageHeader));
    }

    public String getMessagePayload() {
        return this.messagePayload;
    }

    public void setMessagePayload(String messagePayload) {
        this.messagePayload = messagePayload;
    }

    public String getMessagePayloadResource() {
        return this.messagePayloadResource;
    }

    public void setMessagePayloadResource(String messagePayloadResource) {
        this.messagePayloadResource = messagePayloadResource;
    }

    public String getMessagePayloadResourceCharset() {
        return this.messagePayloadResourceCharset;
    }

    public void setMessagePayloadResourceCharset(String messagePayloadResourceCharset) {
        this.messagePayloadResourceCharset = messagePayloadResourceCharset;
    }

    public Map<String, Object> getMessageHeader() {
        return this.messageHeader;
    }

    public void setMessageHeader(Map<String, Object> messageHeader) {
        this.messageHeader = messageHeader;
    }
}

