/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.direct.DirectEndpointConfiguration;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.messaging.Producer;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectProducer
implements Producer {
    private static final Logger logger = LoggerFactory.getLogger(DirectProducer.class);
    private final String name;
    private final DirectEndpointConfiguration endpointConfiguration;

    public DirectProducer(String name, DirectEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(Message message, TestContext context) {
        String destinationQueueName = this.getDestinationQueueName();
        logger.debug("Sending message to queue: '{}'", (Object)destinationQueueName);
        logger.debug("Message to send is:\n{}", (Object)message);
        try {
            this.getDestinationQueue(context).send(message);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to send message to queue: '%s'", destinationQueueName), (Throwable)e);
        }
        logger.info("Message was sent to queue: '{}'", (Object)destinationQueueName);
    }

    protected MessageQueue getDestinationQueue(TestContext context) {
        if (this.endpointConfiguration.getQueue() != null) {
            return this.endpointConfiguration.getQueue();
        }
        if (StringUtils.hasText(this.endpointConfiguration.getQueueName())) {
            return this.resolveQueueName(this.endpointConfiguration.getQueueName(), context);
        }
        throw new CitrusRuntimeException("Neither queue name nor queue object is set - please specify destination queue");
    }

    protected String getDestinationQueueName() {
        if (this.endpointConfiguration.getQueue() != null) {
            return this.endpointConfiguration.getQueue().toString();
        }
        if (StringUtils.hasText(this.endpointConfiguration.getQueueName())) {
            return this.endpointConfiguration.getQueueName();
        }
        throw new CitrusRuntimeException("Neither queue name nor queue object is set - please specify destination queue");
    }

    protected MessageQueue resolveQueueName(String queueName, TestContext context) {
        if (context.getReferenceResolver() != null) {
            return (MessageQueue)context.getReferenceResolver().resolve(queueName, MessageQueue.class);
        }
        throw new CitrusRuntimeException("Unable to resolve message queue - missing proper reference resolver in context");
    }

    public String getName() {
        return this.name;
    }
}

