/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DefaultMessage;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipMessage
extends DefaultMessage {
    private static final Logger logger = LoggerFactory.getLogger(ZipMessage.class);
    private final List<Entry> entries = new ArrayList<Entry>();

    public byte[] getPayload() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(bos);){
            for (Entry entry : this.entries) {
                this.addToZip("", entry, zos);
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create zip archive", (Throwable)e);
        }
        return bos.toByteArray();
    }

    public ZipMessage addEntry(Resource resource) {
        try {
            this.addEntry(new Entry(resource.getFile()));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to read zip entry content from given resource: %s", resource.getLocation()), (Throwable)e);
        }
        return this;
    }

    public ZipMessage addEntry(Path resource) {
        try {
            this.addEntry(new Entry(resource.toFile()));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to read zip entry content from given resource: %s", resource), (Throwable)e);
        }
        return this;
    }

    public ZipMessage addEntry(File file) {
        try {
            this.addEntry(new Entry(file));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read zip entry content from given file", (Throwable)e);
        }
        return this;
    }

    public ZipMessage addEntry(String fileName, byte[] content) {
        Entry entry = new Entry(fileName);
        entry.setContent(content);
        this.addEntry(entry);
        return this;
    }

    public ZipMessage addEntry(Entry entry) {
        this.entries.add(entry);
        return this;
    }

    private void addToZip(String path, Entry entry, ZipOutputStream zos) throws IOException {
        String name = (String)(path.endsWith("/") ? path : path + "/") + entry.getName();
        if (entry.isDirectory()) {
            logger.debug("Adding directory to zip: " + name);
            zos.putNextEntry(new ZipEntry(name.endsWith("/") ? name : name + "/"));
            for (Entry child : entry.getEntries()) {
                if (!StringUtils.hasText(path)) {
                    this.addToZip(entry.getName(), child, zos);
                    continue;
                }
                this.addToZip(name, child, zos);
            }
            zos.closeEntry();
        } else {
            logger.debug("Adding file to zip: " + name);
            zos.putNextEntry(new ZipEntry(name));
            zos.write(entry.getContent());
            zos.closeEntry();
        }
    }

    public static class Entry {
        private final String name;
        private final List<Entry> entries = new ArrayList<Entry>();
        private byte[] content;

        public Entry(String name) {
            this.name = name;
        }

        public Entry(File file) throws IOException {
            this((String)(file.isDirectory() ? file.getName() + "/" : file.getName()), file);
        }

        public Entry(String name, File file) throws IOException {
            this(name);
            if (file.isDirectory()) {
                for (File child : Optional.ofNullable(file.listFiles()).orElseGet(() -> new File[0])) {
                    this.entries.add(new Entry(child));
                }
            } else {
                this.content = FileUtils.copyToByteArray(file);
            }
        }

        public String getName() {
            return this.name;
        }

        public boolean isDirectory() {
            return StringUtils.hasText(this.name) && this.name.endsWith("/");
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        public Entry addEntry(Entry entry) {
            this.entries.add(entry);
            return this;
        }

        public byte[] getContent() {
            return this.content;
        }

        public void setContent(byte[] content) {
            this.content = content;
        }
    }
}

