/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.message.selector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageSelector;
import org.citrusframework.message.MessageSelectorBuilder;
import org.citrusframework.message.selector.HeaderMatchingMessageSelector;

public class DelegatingMessageSelector
implements MessageSelector {
    private final Map<String, String> matchingHeaders;
    private final List<MessageSelector.MessageSelectorFactory> factories;
    private final TestContext context;

    public DelegatingMessageSelector(String selector, TestContext context) {
        this.context = context;
        this.matchingHeaders = MessageSelectorBuilder.withString(selector).toKeyValueMap();
        if (this.matchingHeaders.isEmpty()) {
            throw new CitrusRuntimeException("Invalid empty message selector");
        }
        this.factories = new ArrayList<MessageSelector.MessageSelectorFactory>();
        if (context.getReferenceResolver() != null) {
            this.factories.addAll(context.getReferenceResolver().resolveAll(MessageSelector.MessageSelectorFactory.class).values());
        }
        this.factories.addAll(MessageSelector.lookup().values());
    }

    public boolean accept(Message message) {
        return this.matchingHeaders.entrySet().stream().allMatch(entry -> this.factories.stream().filter(factory -> factory.supports((String)entry.getKey())).findAny().orElseGet(HeaderMatchingMessageSelector.Factory::new).create((String)entry.getKey(), (String)entry.getValue(), this.context).accept(message));
    }

    public void addMessageSelectorFactory(MessageSelector.MessageSelectorFactory factory) {
        this.factories.add(factory);
    }
}

