/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.DefaultTestActions;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestActionContainerBuilder;
import org.citrusframework.container.TestActionContainer;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;

public abstract class AbstractTestContainerBuilder<T extends TestActionContainer, S extends TestActionContainerBuilder<T, S>>
extends AbstractTestActionBuilder<T, S>
implements TestActionContainerBuilder<T, S>,
ReferenceResolverAware {
    protected final List<TestActionBuilder<?>> actions = new ArrayList();
    protected ReferenceResolver referenceResolver;

    public S actions(TestAction ... actions) {
        return this.actions(Stream.of(actions).map(action -> () -> action).toList().toArray(new TestActionBuilder[0]));
    }

    public S actions(TestActionBuilder<?> ... actions) {
        for (int i = 0; i < actions.length; ++i) {
            TestActionBuilder<?> current = actions[i];
            if (this.actions.size() == i) {
                this.actions.add(current);
                continue;
            }
            if (this.resolveActionBuilder(this.actions.get(i)).equals(this.resolveActionBuilder(current))) continue;
            this.actions.add(i, current);
        }
        return (S)((TestActionContainerBuilder)this.self);
    }

    private TestActionBuilder<?> resolveActionBuilder(TestActionBuilder<?> builder) {
        if (builder instanceof TestActionBuilder.DelegatingTestActionBuilder) {
            return this.resolveActionBuilder(((TestActionBuilder.DelegatingTestActionBuilder)builder).getDelegate());
        }
        return builder;
    }

    public T build() {
        if (this.referenceResolver != null) {
            for (TestActionBuilder<?> builder : this.actions) {
                if (!(builder instanceof ReferenceResolverAware)) continue;
                ReferenceResolverAware referenceResolverAware = (ReferenceResolverAware)builder;
                referenceResolverAware.setReferenceResolver(this.referenceResolver);
            }
        }
        return this.doBuild();
    }

    protected abstract T doBuild();

    public List<TestActionBuilder<?>> getActions() {
        return this.actions;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public static <T extends TestActionContainer, B extends TestActionContainerBuilder<T, B>> TestActionContainerBuilder<T, B> container(T container) {
        return new DefaultTestActions().container(container);
    }
}

