/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.Map;
import java.util.Optional;
import org.citrusframework.CitrusContext;
import org.citrusframework.DefaultCitrusContextProvider;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ResourcePathTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CitrusContextProvider {
    public static final Logger logger = LoggerFactory.getLogger(CitrusContextProvider.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/context/provider";
    public static final ResourcePathTypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/context/provider");
    public static final String SPRING = "spring";

    public CitrusContext create();

    public static CitrusContextProvider lookup() {
        Map provider = TYPE_RESOLVER.resolveAll("", "*");
        if (provider.isEmpty()) {
            logger.debug("Using default Citrus context provider");
            return new DefaultCitrusContextProvider();
        }
        if (provider.size() > 1) {
            logger.warn("Found {} Citrus context provider implementations. Please choose one of them.", (Object)provider.size());
        }
        if (logger.isDebugEnabled()) {
            provider.forEach((k, v) -> logger.debug("Found Citrus context provider '{}' as {}", k, v.getClass()));
        }
        CitrusContextProvider contextProvider = (CitrusContextProvider)provider.values().iterator().next();
        logger.debug("Using Citrus context provider '{}' as {}", provider.keySet().iterator().next(), (Object)contextProvider);
        return contextProvider;
    }

    public static Optional<CitrusContextProvider> lookup(String name) {
        try {
            CitrusContextProvider instance = (CitrusContextProvider)TYPE_RESOLVER.resolve(name, new Object[0]);
            return Optional.of(instance);
        }
        catch (CitrusRuntimeException e) {
            logger.warn("Failed to resolve Citrus context provider from resource '{}/{}'", (Object)RESOURCE_PATH, (Object)name);
            return Optional.empty();
        }
    }
}

