/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import java.time.Duration;
import org.citrusframework.AbstractIteratingContainerBuilder;
import org.citrusframework.container.AbstractIteratingActionContainer;
import org.citrusframework.container.IteratingConditionExpression;
import org.citrusframework.container.RepeatOnErrorUntilTrueContainerBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatOnErrorUntilTrue
extends AbstractIteratingActionContainer {
    private static final Logger logger = LoggerFactory.getLogger(RepeatOnErrorUntilTrue.class);
    private final Duration autoSleep;

    public RepeatOnErrorUntilTrue(Builder builder) {
        super("repeat-on-error", builder);
        this.autoSleep = builder.autoSleep;
    }

    @Override
    public void executeIteration(TestContext context) {
        CitrusRuntimeException exception = null;
        while (!this.checkCondition(context)) {
            try {
                exception = null;
                this.executeActions(context);
                break;
            }
            catch (CitrusRuntimeException e) {
                exception = e;
                logger.info("Caught exception of type {} '{}' - performing retry #{}", new Object[]{((Object)((Object)e)).getClass().getName(), e.getMessage(), this.index});
                this.doAutoSleep();
                ++this.index;
            }
        }
        if (exception != null) {
            logger.info("All retries failed - raising exception {}", (Object)((Object)((Object)exception)).getClass().getName());
            throw exception;
        }
    }

    private void doAutoSleep() {
        if (this.autoSleep.toMillis() > 0L) {
            logger.info("Sleeping {}", (Object)this.autoSleep);
            try {
                Thread.sleep(this.autoSleep.toMillis());
            }
            catch (InterruptedException e) {
                logger.error("Error during doc generation", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            logger.info("Returning after {}", (Object)this.autoSleep);
        }
    }

    @Deprecated(forRemoval=true)
    public Long getAutoSleep() {
        return this.autoSleep.toMillis();
    }

    public Duration getAutoSleepDuration() {
        return this.autoSleep;
    }

    public static class Builder
    extends AbstractIteratingContainerBuilder<RepeatOnErrorUntilTrue, Builder>
    implements RepeatOnErrorUntilTrueContainerBuilder<RepeatOnErrorUntilTrue, Builder> {
        private Duration autoSleep = Duration.ofMillis(1000L);

        public static Builder repeatOnError() {
            return new Builder();
        }

        public Builder until(String condition) {
            this.condition(condition);
            return this;
        }

        public Builder until(IteratingConditionExpression condition) {
            this.condition(condition);
            return this;
        }

        public Builder autoSleep(long autoSleepInMillis) {
            this.autoSleep = Duration.ofMillis(autoSleepInMillis);
            return this;
        }

        public Builder autoSleep(Duration autoSleep) {
            this.autoSleep = autoSleep;
            return this;
        }

        @Override
        public RepeatOnErrorUntilTrue doBuild() {
            return new RepeatOnErrorUntilTrue(this);
        }
    }
}

