/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.citrusframework.CitrusSettings;
import org.citrusframework.annotations.CitrusEndpoint;
import org.citrusframework.annotations.CitrusEndpointConfig;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.ShutdownPhase;
import org.citrusframework.config.annotation.AnnotationConfigParser;
import org.citrusframework.context.TestContext;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.endpoint.EndpointBuilder;
import org.citrusframework.endpoint.EndpointComponent;
import org.citrusframework.endpoint.EndpointFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEndpointFactory
implements EndpointFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEndpointFactory.class);
    private final Map<String, Endpoint> endpointCache = new ConcurrentHashMap<String, Endpoint>();

    public Endpoint create(String endpointName, Annotation endpointConfig, TestContext context) {
        String qualifier = endpointConfig.annotationType().getAnnotation(CitrusEndpointConfig.class).qualifier();
        Optional parser = Optional.ofNullable((AnnotationConfigParser)context.getReferenceResolver().resolveAll(AnnotationConfigParser.class).get(qualifier));
        if (!parser.isPresent()) {
            parser = AnnotationConfigParser.lookup((String)qualifier);
        }
        if (parser.isPresent()) {
            Endpoint endpoint = ((AnnotationConfigParser)parser.get()).parse(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            if (endpoint instanceof ReferenceResolverAware) {
                ReferenceResolverAware referenceResolverAware = (ReferenceResolverAware)endpoint;
                referenceResolverAware.setReferenceResolver(context.getReferenceResolver());
            }
            if (endpoint instanceof InitializingPhase) {
                InitializingPhase initializingBean = (InitializingPhase)endpoint;
                initializingBean.initialize();
            }
            PropertyUtils.configure(endpointName, endpoint, context.getReferenceResolver());
            return endpoint;
        }
        throw new CitrusRuntimeException(String.format("Unable to create endpoint annotation parser with name '%s'", qualifier));
    }

    public Endpoint create(String endpointName, CitrusEndpoint endpointConfig, Class<?> endpointType, TestContext context) {
        Optional<EndpointBuilder> builder = context.getReferenceResolver().resolveAll(EndpointBuilder.class).values().stream().filter(endpointBuilder -> endpointBuilder.supports(endpointType)).findFirst();
        if (builder.isPresent()) {
            Endpoint endpoint = builder.get().build(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        Optional<EndpointBuilder> lookup = EndpointBuilder.lookup().values().stream().filter(endpointBuilder -> endpointBuilder.supports(endpointType)).findFirst();
        if (lookup.isPresent()) {
            Endpoint endpoint = lookup.get().build(endpointConfig, context.getReferenceResolver());
            endpoint.setName(endpointName);
            return endpoint;
        }
        throw new CitrusRuntimeException(String.format("Unable to create endpoint builder for type '%s'", endpointType.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint create(String uri, TestContext context) {
        String endpointUri = context.replaceDynamicContentInString(uri);
        if (!endpointUri.contains(":")) {
            if (context.getReferenceResolver().isResolvable(endpointUri, Endpoint.class)) {
                return (Endpoint)context.getReferenceResolver().resolve(endpointUri, Endpoint.class);
            }
            Map<String, Endpoint> map = this.endpointCache;
            synchronized (map) {
                if (this.endpointCache.containsKey(endpointUri)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Found cached endpoint for uri '{}'", (Object)endpointUri);
                    }
                    return this.endpointCache.get(endpointUri);
                }
            }
        }
        String componentName = DefaultEndpointFactory.getComponentName(endpointUri);
        Optional component = Optional.ofNullable(this.getEndpointComponents(context.getReferenceResolver()).get(componentName));
        if (component.isEmpty()) {
            component = EndpointComponent.lookup((String)componentName);
        }
        if (component.isEmpty()) {
            throw new CitrusRuntimeException(String.format("Unable to create endpoint component with name '%s'", componentName));
        }
        Map parameters = ((EndpointComponent)component.get()).getParameters(endpointUri);
        String cachedEndpointName = parameters.getOrDefault("endpointName", endpointUri);
        Map<String, Endpoint> map = this.endpointCache;
        synchronized (map) {
            if (this.endpointCache.containsKey(cachedEndpointName)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found cached endpoint for uri '{}'", (Object)cachedEndpointName);
                }
                return this.endpointCache.get(cachedEndpointName);
            }
            Endpoint endpoint = ((EndpointComponent)component.get()).createEndpoint(endpointUri, context);
            this.endpointCache.put(cachedEndpointName, endpoint);
            boolean autoRemove = Optional.ofNullable((String)parameters.get("autoRemove")).map(Boolean::parseBoolean).orElseGet(CitrusSettings::isAutoRemoveDynamicEndpoints);
            if (autoRemove) {
                context.doFinally(() -> ctx -> {
                    logger.info("Stopping and removing endpoint '{}' due to auto remove setting", (Object)endpoint.getName());
                    if (endpoint instanceof ShutdownPhase) {
                        ShutdownPhase destroyable = (ShutdownPhase)endpoint;
                        destroyable.destroy();
                    }
                    Map<String, Endpoint> map = this.endpointCache;
                    synchronized (map) {
                        this.endpointCache.remove(cachedEndpointName);
                    }
                });
            }
            return endpoint;
        }
    }

    private static String getComponentName(String endpointUri) {
        String componentName = endpointUri;
        if (componentName.contains("?")) {
            componentName = componentName.substring(0, componentName.indexOf("?"));
        }
        if (componentName.contains(":")) {
            componentName = componentName.substring(0, componentName.indexOf(":"));
        }
        if (componentName.isEmpty() || endpointUri.endsWith(":") || endpointUri.endsWith("?")) {
            throw new CitrusRuntimeException(String.format("Invalid endpoint uri '%s'", endpointUri));
        }
        return componentName;
    }

    private Map<String, EndpointComponent> getEndpointComponents(ReferenceResolver referenceResolver) {
        return referenceResolver.resolveAll(EndpointComponent.class);
    }
}

