/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import com.mifmif.common.regex.Generex;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.util.StringUtils;

public class RandomPatternFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList == null) {
            throw new InvalidFunctionUsageException("Function parameters must not be null.");
        }
        String pattern = parameterList.get(0);
        if (!StringUtils.hasText(pattern)) {
            throw new InvalidFunctionUsageException("Pattern must not be empty.");
        }
        if (!Generex.isValidPattern((String)pattern)) {
            throw new IllegalArgumentException("Function called with a pattern, the algorithm is not able to create a string for.");
        }
        return new Generex(pattern).random();
    }
}

