/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;

public class RandomStringFunction
implements Function {
    private static final Random random = new Random(System.currentTimeMillis());
    private static final char[] ALPHABET_UPPER = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] ALPHABET_LOWER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] ALPHABET_MIXED = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final String UPPERCASE = "UPPERCASE";
    public static final String LOWERCASE = "LOWERCASE";
    public static final String MIXED = "MIXED";

    public String execute(List<String> parameterList, TestContext context) {
        String notationMethod = MIXED;
        boolean includeNumbers = false;
        int minNumberOfLetters = -1;
        if (parameterList == null || parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        if (parameterList.size() > 4) {
            throw new InvalidFunctionUsageException("Too many parameters for function");
        }
        int numberOfLetters = Integer.parseInt(parameterList.get(0));
        if (numberOfLetters < 0) {
            throw new InvalidFunctionUsageException("Invalid parameter definition. Number of letters must not be positive non-zero integer value");
        }
        if (parameterList.size() > 1) {
            notationMethod = parameterList.get(1);
        }
        if (parameterList.size() > 2) {
            includeNumbers = Boolean.parseBoolean(parameterList.get(2));
        }
        if (parameterList.size() > 3) {
            minNumberOfLetters = Integer.parseInt(parameterList.get(3));
        }
        if (notationMethod.equals(UPPERCASE)) {
            return RandomStringFunction.getRandomString(numberOfLetters, ALPHABET_UPPER, includeNumbers, minNumberOfLetters);
        }
        if (notationMethod.equals(LOWERCASE)) {
            return RandomStringFunction.getRandomString(numberOfLetters, ALPHABET_LOWER, includeNumbers, minNumberOfLetters);
        }
        return RandomStringFunction.getRandomString(numberOfLetters, ALPHABET_MIXED, includeNumbers, minNumberOfLetters);
    }

    public static String getRandomString(int numberOfLetters, char[] alphabet, boolean includeNumbers, int minNumberOfLetters) {
        StringBuilder builder = new StringBuilder();
        int upperRange = alphabet.length - 1;
        builder.append(alphabet[random.nextInt(upperRange)]);
        if (includeNumbers) {
            upperRange += NUMBERS.length;
        }
        if (minNumberOfLetters > -1) {
            numberOfLetters = ThreadLocalRandom.current().nextInt(minNumberOfLetters, numberOfLetters + 1);
        }
        for (int i = 1; i < numberOfLetters; ++i) {
            int letterIndex = random.nextInt(upperRange);
            if (letterIndex > alphabet.length - 1) {
                builder.append(NUMBERS[letterIndex - alphabet.length]);
                continue;
            }
            builder.append(alphabet[letterIndex]);
        }
        return builder.toString();
    }
}

