/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation;

import java.util.HashMap;
import java.util.Map;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.DelegatingPathExpressionProcessor;
import org.citrusframework.message.MessageProcessor;
import org.citrusframework.validation.DelegatingPayloadVariableExtractor;
import org.citrusframework.validation.context.DefaultValidationContext;
import org.citrusframework.validation.context.ValidationContext;
import org.citrusframework.validation.expression.PathExpressionValidationContextBuilder;
import org.citrusframework.validation.json.JsonPathMessageValidationContext;
import org.citrusframework.validation.xml.XpathMessageValidationContext;
import org.citrusframework.variable.VariableExtractor;

public class PathExpressionValidationContext {
    private PathExpressionValidationContext() {
    }

    public static final class Builder
    implements PathExpressionValidationContextBuilder<ValidationContext, Builder> {
        private final Map<String, Object> expressions = new HashMap<String, Object>();

        public static Builder pathExpression() {
            return new Builder();
        }

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object value) {
            this.expressions.put(expression, value);
            return this;
        }

        public Builder jsonPath(String expression, Object value) {
            if (!JsonPathMessageValidationContext.isJsonPathExpression(expression)) {
                throw new CitrusRuntimeException(String.format("Unsupported json path expression '%s'", expression));
            }
            return this.expression(expression, value);
        }

        public Builder xpath(String expression, Object value) {
            if (!XpathMessageValidationContext.isXpathExpression(expression)) {
                throw new CitrusRuntimeException(String.format("Unsupported xpath expression '%s'", expression));
            }
            return this.expression(expression, value);
        }

        public MessageProcessor asProcessor() {
            return ((DelegatingPathExpressionProcessor.Builder)new DelegatingPathExpressionProcessor.Builder().expressions((Map)this.expressions)).build();
        }

        public VariableExtractor asExtractor() {
            return ((DelegatingPayloadVariableExtractor.Builder)new DelegatingPayloadVariableExtractor.Builder().expressions((Map)this.expressions)).build();
        }

        public ValidationContext build() {
            if (this.expressions.isEmpty()) {
                return new DefaultValidationContext();
            }
            String expression = this.expressions.keySet().iterator().next();
            if (JsonPathMessageValidationContext.isJsonPathExpression(expression)) {
                return ((JsonPathMessageValidationContext.Builder)new JsonPathMessageValidationContext.Builder().expressions((Map)this.expressions)).build();
            }
            if (XpathMessageValidationContext.isXpathExpression(expression)) {
                return new XpathMessageValidationContext.Builder().expressions(this.expressions).build();
            }
            throw new CitrusRuntimeException(String.format("Unsupported path expression '%s'", expression));
        }
    }
}

