/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusContextProvider;
import org.citrusframework.CitrusInstanceProcessor;
import org.citrusframework.CitrusInstanceStrategy;
import org.citrusframework.DefaultCitrusContextProvider;

public class CitrusInstanceManager {
    private static Citrus citrus;
    private static final List<CitrusInstanceProcessor> instanceProcessors;
    protected static CitrusInstanceStrategy strategy;

    public static void addInstanceProcessor(CitrusInstanceProcessor processor) {
        instanceProcessors.add(processor);
    }

    public static Citrus newInstance() {
        return CitrusInstanceManager.newInstance(CitrusContextProvider.lookup());
    }

    public static Citrus newInstance(CitrusContextProvider contextProvider) {
        if (strategy.equals((Object)CitrusInstanceStrategy.NEW) || citrus == null) {
            citrus = new Citrus(contextProvider.create());
            instanceProcessors.forEach(processor -> processor.process(citrus));
        }
        return citrus;
    }

    public static void mode(CitrusInstanceStrategy mode) {
        strategy = mode;
    }

    public static Optional<Citrus> get() {
        return Optional.ofNullable(citrus);
    }

    public static Citrus getOrDefault() {
        if (citrus == null) {
            citrus = CitrusInstanceManager.newInstance();
        }
        return citrus;
    }

    public static boolean hasInstance() {
        return citrus != null;
    }

    public static void reset() {
        if (citrus != null) {
            citrus.close();
            DefaultCitrusContextProvider.reset();
        }
        citrus = null;
    }

    static {
        instanceProcessors = new ArrayList<CitrusInstanceProcessor>();
        strategy = CitrusInstanceStrategy.NEW;
    }
}

