/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.common;

import java.util.Optional;
import org.citrusframework.TestSource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public final class TestSourceHelper {
    private TestSourceHelper() {
    }

    public static TestSource create(String filePath) {
        if (filePath == null) {
            return null;
        }
        String fileName = FileUtils.getBaseName(FileUtils.getFileName(filePath));
        String ext = FileUtils.getFileExtension(filePath);
        if (StringUtils.hasText(ext)) {
            return new TestSource(ext, fileName, filePath);
        }
        return new TestSource("directory", fileName, filePath);
    }

    public static TestSource create(String filePath, String sourceCode) {
        return Optional.ofNullable(TestSourceHelper.create(filePath)).map(ts -> ts.sourceCode(sourceCode)).orElse(null);
    }
}

