/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.container;

import org.citrusframework.AbstractTestContainerBuilder;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.container.AbstractActionContainer;
import org.citrusframework.container.ConditionExpression;
import org.citrusframework.container.ConditionalContainerBuilder;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.util.BooleanExpressionParser;
import org.citrusframework.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conditional
extends AbstractActionContainer {
    private static final Logger logger = LoggerFactory.getLogger(Conditional.class);
    private final String condition;
    private final ConditionExpression conditionExpression;

    public Conditional(Builder builder) {
        super("conditional", builder);
        this.condition = builder.condition;
        this.conditionExpression = builder.conditionExpression;
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.checkCondition(context)) {
            logger.debug("Condition [ {} ] evaluates to true, executing nested actions", (Object)this.condition);
            for (TestActionBuilder actionBuilder : this.actions) {
                this.executeAction(actionBuilder.build(), context);
            }
        } else {
            logger.debug("Condition [ {} ] evaluates to false, not executing nested actions", (Object)this.condition);
        }
    }

    private boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(context);
        }
        String conditionString = context.replaceDynamicContentInString(this.condition);
        if (ValidationMatcherUtils.isValidationMatcherExpression((String)conditionString)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher((String)"iteratingCondition", (String)"", (String)conditionString, (TestContext)context);
                return true;
            }
            catch (AssertionError | ValidationException e) {
                return false;
            }
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public String getCondition() {
        return this.condition;
    }

    public ConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public static class Builder
    extends AbstractTestContainerBuilder<Conditional, Builder>
    implements ConditionalContainerBuilder<Conditional, Builder> {
        protected String condition;
        private ConditionExpression conditionExpression;

        public static Builder conditional() {
            return new Builder();
        }

        public Builder when(String expression) {
            this.condition = expression;
            return this;
        }

        public Builder when(ConditionExpression expression) {
            this.conditionExpression = expression;
            return this;
        }

        @Override
        public Conditional doBuild() {
            return new Conditional(this);
        }
    }
}

