/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.direct.DirectEndpoint;
import org.citrusframework.message.DefaultMessageQueue;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.util.PropertyUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.SchemaProperty;

public class DirectEndpointBuilder
extends AbstractEndpointBuilder<DirectEndpoint> {
    private final DirectEndpoint endpoint = new DirectEndpoint();
    private boolean autoCreateQueue;

    @Override
    public DirectEndpoint build() {
        if (this.referenceResolver != null && this.autoCreateQueue) {
            String createdQueue = null;
            if (StringUtils.hasText(this.endpoint.getEndpointConfiguration().getQueueName()) && !this.referenceResolver.isResolvable(this.endpoint.getEndpointConfiguration().getQueueName(), MessageQueue.class)) {
                DefaultMessageQueue messageQueue = new DefaultMessageQueue(this.endpoint.getEndpointConfiguration().getQueueName());
                PropertyUtils.configure(this.endpoint.getEndpointConfiguration().getQueueName(), messageQueue, this.referenceResolver);
                this.referenceResolver.bind(this.endpoint.getEndpointConfiguration().getQueueName(), (Object)messageQueue);
                createdQueue = messageQueue.getName();
            } else if (this.endpoint.getEndpointConfiguration().getQueue() != null && !this.referenceResolver.isResolvable(this.endpoint.getEndpointConfiguration().getQueue().getName(), MessageQueue.class)) {
                this.referenceResolver.bind(this.endpoint.getEndpointConfiguration().getQueue().getName(), (Object)this.endpoint.getEndpointConfiguration().getQueue());
                createdQueue = this.endpoint.getEndpointConfiguration().getQueue().getName();
            }
            if (StringUtils.hasText(createdQueue)) {
                logger.info("Automatically created queue '{}'", createdQueue);
            }
        }
        return (DirectEndpoint)super.build();
    }

    @Override
    protected DirectEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DirectEndpointBuilder queue(String queueName) {
        this.endpoint.getEndpointConfiguration().setQueueName(queueName);
        return this;
    }

    @SchemaProperty(description="The queue name.")
    public void setQueue(String queueName) {
        this.queue(queueName);
    }

    public DirectEndpointBuilder queue(MessageQueue queue) {
        this.endpoint.getEndpointConfiguration().setQueue(queue);
        return this;
    }

    public DirectEndpointBuilder autoCreateQueue(boolean autoCreate) {
        this.autoCreateQueue = autoCreate;
        return this;
    }

    @SchemaProperty(description="When set the queue is automatically created when it does not exist in bean registry.")
    public void setAutoCreateQueue(boolean autoCreate) {
        this.autoCreateQueue(autoCreate);
    }

    public DirectEndpointBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }

    @SchemaProperty(description="The timeout when receiving messages from the queue.")
    public void setTimeout(long timeout) {
        this.timeout(timeout);
    }
}

