/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.endpoint.direct;

import org.citrusframework.endpoint.AbstractEndpointBuilder;
import org.citrusframework.endpoint.direct.DirectSyncEndpoint;
import org.citrusframework.message.DefaultMessageQueue;
import org.citrusframework.message.MessageCorrelator;
import org.citrusframework.message.MessageQueue;
import org.citrusframework.util.PropertyUtils;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.SchemaProperty;

public class DirectSyncEndpointBuilder
extends AbstractEndpointBuilder<DirectSyncEndpoint> {
    private final DirectSyncEndpoint endpoint = new DirectSyncEndpoint();
    private String correlator;
    private boolean autoCreateQueue;

    @Override
    public DirectSyncEndpoint build() {
        if (this.referenceResolver != null) {
            if (StringUtils.hasText(this.correlator)) {
                this.correlator((MessageCorrelator)this.referenceResolver.resolve(this.correlator, MessageCorrelator.class));
            }
            if (this.autoCreateQueue) {
                String createdQueue = null;
                if (StringUtils.hasText(this.endpoint.getEndpointConfiguration().getQueueName()) && !this.referenceResolver.isResolvable(this.endpoint.getEndpointConfiguration().getQueueName(), MessageQueue.class)) {
                    DefaultMessageQueue messageQueue = new DefaultMessageQueue(this.endpoint.getEndpointConfiguration().getQueueName());
                    PropertyUtils.configure(this.endpoint.getEndpointConfiguration().getQueueName(), messageQueue, this.referenceResolver);
                    this.referenceResolver.bind(this.endpoint.getEndpointConfiguration().getQueueName(), (Object)messageQueue);
                    createdQueue = messageQueue.getName();
                } else if (this.endpoint.getEndpointConfiguration().getQueue() != null && !this.referenceResolver.isResolvable(this.endpoint.getEndpointConfiguration().getQueue().getName(), MessageQueue.class)) {
                    this.referenceResolver.bind(this.endpoint.getEndpointConfiguration().getQueue().getName(), (Object)this.endpoint.getEndpointConfiguration().getQueue());
                    createdQueue = this.endpoint.getEndpointConfiguration().getQueue().getName();
                }
                if (StringUtils.hasText(createdQueue)) {
                    logger.info("Automatically created queue '{}'", createdQueue);
                }
            }
        }
        return (DirectSyncEndpoint)super.build();
    }

    @Override
    protected DirectSyncEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DirectSyncEndpointBuilder queue(String queueName) {
        this.endpoint.getEndpointConfiguration().setQueueName(queueName);
        return this;
    }

    @SchemaProperty(description="The queue name.")
    public void setQueue(String queueName) {
        this.queue(queueName);
    }

    public DirectSyncEndpointBuilder queue(MessageQueue queue) {
        this.endpoint.getEndpointConfiguration().setQueue(queue);
        return this;
    }

    public DirectSyncEndpointBuilder autoCreateQueue(boolean autoCreate) {
        this.autoCreateQueue = autoCreate;
        return this;
    }

    @SchemaProperty(description="When set the queue is automatically created when it does not exist in bean registry.")
    public void setAutoCreateQueue(boolean autoCreate) {
        this.autoCreateQueue(autoCreate);
    }

    public DirectSyncEndpointBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    @SchemaProperty(description="Sets the polling interval when consuming messages.")
    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval(pollingInterval);
    }

    public DirectSyncEndpointBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    @SchemaProperty(advanced=true, description="Sets the message correlator.")
    public void setCorrelator(String correlator) {
        this.correlator = correlator;
    }

    public DirectSyncEndpointBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }

    @SchemaProperty(description="The timeout when receiving messages from the queue.")
    public void setTimeout(long timeout) {
        this.timeout(timeout);
    }
}

