/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.functions.core.DateFunctionHelper;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.SchemaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentDateFunction
implements ParameterizedFunction<Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(CurrentDateFunction.class);

    public String execute(Parameters params, TestContext context) {
        String result;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = StringUtils.hasText(params.getDateFormat()) ? new SimpleDateFormat(params.getDateFormat()) : DateFunctionHelper.getDefaultDateFormat();
        if (StringUtils.hasText(params.getOffset())) {
            DateFunctionHelper.applyDateOffset(calendar, params.getOffset());
        }
        if (StringUtils.hasText(params.getTimeZone())) {
            dateFormat.setTimeZone(TimeZone.getTimeZone(params.getTimeZone()));
        }
        try {
            result = dateFormat.format(calendar.getTime());
        }
        catch (RuntimeException e) {
            logger.error("Error while formatting date value ", (Throwable)e);
            throw new CitrusRuntimeException((Throwable)e);
        }
        return result;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String dateFormat;
        private String offset;
        private String timeZone;

        public void configure(List<String> parameterList, TestContext context) {
            if (!parameterList.isEmpty()) {
                this.setDateFormat(parameterList.get(0));
            }
            if (parameterList.size() > 1) {
                this.setOffset(parameterList.get(1));
            }
            if (parameterList.size() > 2) {
                this.setTimeZone(parameterList.get(2));
            }
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        @SchemaProperty(description="The date format string.")
        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }

        public String getOffset() {
            return this.offset;
        }

        @SchemaProperty(description="The date offset.")
        public void setOffset(String offset) {
            this.offset = offset;
        }

        public String getTimeZone() {
            return this.timeZone;
        }

        @SchemaProperty(description="The time zone.")
        public void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }
    }
}

