/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class RandomStringFunction
implements ParameterizedFunction<Parameters> {
    private static final Random random = new Random(System.currentTimeMillis());
    private static final char[] ALPHABET_UPPER = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] ALPHABET_LOWER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] ALPHABET_MIXED = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] NUMBERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public String execute(Parameters params, TestContext context) {
        return RandomStringFunction.getRandomString(params);
    }

    public static String getRandomString(Parameters params) {
        if (params.getNotationMethod().equals((Object)NotationMethod.UPPERCASE)) {
            return RandomStringFunction.getRandomString(params, ALPHABET_UPPER);
        }
        if (params.getNotationMethod().equals((Object)NotationMethod.LOWERCASE)) {
            return RandomStringFunction.getRandomString(params, ALPHABET_LOWER);
        }
        return RandomStringFunction.getRandomString(params, ALPHABET_MIXED);
    }

    public static String getRandomString(Parameters params, char[] alphabet) {
        return RandomStringFunction.getRandomString(params.getLength(), alphabet, params.isIncludeNumbers(), params.getMinNumberOfLetters());
    }

    public static String getRandomString(int numberOfLetters, char[] alphabet, boolean includeNumbers, int minNumberOfLetters) {
        StringBuilder builder = new StringBuilder();
        int upperRange = alphabet.length - 1;
        builder.append(alphabet[random.nextInt(upperRange)]);
        if (includeNumbers) {
            upperRange += NUMBERS.length;
        }
        if (minNumberOfLetters > -1) {
            numberOfLetters = ThreadLocalRandom.current().nextInt(minNumberOfLetters, numberOfLetters + 1);
        }
        for (int i = 1; i < numberOfLetters; ++i) {
            int letterIndex = random.nextInt(upperRange);
            if (letterIndex > alphabet.length - 1) {
                builder.append(NUMBERS[letterIndex - alphabet.length]);
                continue;
            }
            builder.append(alphabet[letterIndex]);
        }
        return builder.toString();
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private int length;
        private NotationMethod notationMethod = NotationMethod.MIXED;
        private boolean includeNumbers = false;
        private int minNumberOfLetters = -1;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Function parameters must not be empty");
            }
            if (parameterList.size() > 4) {
                throw new InvalidFunctionUsageException("Too many parameters for function");
            }
            this.setLength(Integer.parseInt(parameterList.get(0)));
            if (this.getLength() < 0) {
                throw new InvalidFunctionUsageException("Invalid parameter definition. Number of letters must not be positive non-zero integer value");
            }
            if (parameterList.size() > 1) {
                if (Arrays.stream(NotationMethod.values()).map(Enum::name).anyMatch(parameterList.get(1)::equals)) {
                    this.setNotationMethod(NotationMethod.valueOf(parameterList.get(1)));
                }
            }
            if (parameterList.size() > 2) {
                this.setIncludeNumbers(Boolean.parseBoolean(parameterList.get(2)));
            }
            if (parameterList.size() > 3) {
                this.setMinNumberOfLetters(Integer.parseInt(parameterList.get(3)));
            }
        }

        public int getLength() {
            return this.length;
        }

        @SchemaProperty(required=true, description="Defines the length of the generated string.")
        public void setLength(int length) {
            this.length = length;
        }

        public boolean isIncludeNumbers() {
            return this.includeNumbers;
        }

        public void setIncludeNumbers(boolean includeNumbers) {
            this.includeNumbers = includeNumbers;
        }

        public int getMinNumberOfLetters() {
            return this.minNumberOfLetters;
        }

        @SchemaProperty(description="Number of letters that must be part of the generated string.")
        public void setMinNumberOfLetters(int minNumberOfLetters) {
            this.minNumberOfLetters = minNumberOfLetters;
        }

        public NotationMethod getNotationMethod() {
            return this.notationMethod;
        }

        @SchemaProperty(description="The notation method to use.")
        public void setNotationMethod(NotationMethod notationMethod) {
            this.notationMethod = notationMethod;
        }
    }

    public static enum NotationMethod {
        MIXED,
        UPPERCASE,
        LOWERCASE;

    }
}

