/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.io.IOException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaml.SchemaProperty;

public class ReadFileResourceFunction
implements ParameterizedFunction<Parameters> {
    public String execute(Parameters param, TestContext context) {
        try {
            if (param.isBase64()) {
                if (param.isUseCharset()) {
                    return Base64.encodeBase64String((byte[])this.readFileContent(param.getFilePath(), context, true).getBytes(FileUtils.getCharset(param.getFilePath())));
                }
                return Base64.encodeBase64String((byte[])FileUtils.copyToByteArray(FileUtils.getFileResource(param.getFilePath(), context)));
            }
            return this.readFileContent(param.getFilePath(), context, true);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read file", (Throwable)e);
        }
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    private String readFileContent(String filePath, TestContext context, boolean replace) throws IOException {
        String content = FileUtils.readToString(FileUtils.getFileResource(filePath, context), FileUtils.getCharset(filePath));
        return replace ? context.replaceDynamicContentInString(content) : content;
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String filePath;
        private boolean base64;
        private boolean useCharset;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Missing file path function parameter");
            }
            this.setFilePath(parameterList.get(0));
            if (parameterList.size() > 1) {
                this.setBase64(Boolean.parseBoolean(parameterList.get(1)));
            }
            if (parameterList.size() > 2) {
                this.setUseCharset(Boolean.parseBoolean(parameterList.get(2)));
            }
        }

        public String getFilePath() {
            return this.filePath;
        }

        @SchemaProperty(required=true, description="The file path to read.")
        public void setFilePath(String path) {
            this.filePath = path;
        }

        public boolean isBase64() {
            return this.base64;
        }

        @SchemaProperty(description="When enabled the read file content is converted into bas64.")
        public void setBase64(boolean paddingOn) {
            this.base64 = paddingOn;
        }

        public boolean isUseCharset() {
            return this.useCharset;
        }

        @SchemaProperty(advanced=true, description="When enabled the charset to use is derived from the file path before converting into bas64.")
        public void setUseCharset(boolean useCharset) {
            this.useCharset = useCharset;
        }
    }
}

