/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class SubstringFunction
implements ParameterizedFunction<Parameters> {
    public String execute(Parameters params, TestContext context) {
        String targetString = params.getValue();
        targetString = params.getEndIndex() > 0 ? targetString.substring(params.getBeginIndex(), params.getEndIndex()) : targetString.substring(params.getBeginIndex());
        return targetString;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String value;
        private int beginIndex;
        private int endIndex;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.size() < 2) {
                throw new InvalidFunctionUsageException("Insufficient function parameters - parameter usage: (targetString, beginIndex, [endIndex])");
            }
            this.setValue(parameterList.get(0));
            this.setBeginIndex(Integer.parseInt(parameterList.get(1)));
            if (parameterList.size() > 2) {
                this.setEndIndex(Integer.parseInt(parameterList.get(2)));
            }
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true, description="The value to perform substring.")
        public void setValue(String value) {
            this.value = value;
        }

        public int getBeginIndex() {
            return this.beginIndex;
        }

        @SchemaProperty(required=true, description="The substring begin index.")
        public void setBeginIndex(int beginIndex) {
            this.beginIndex = beginIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        @SchemaProperty(description="Optional substring end index.")
        public void setEndIndex(int endIndex) {
            this.endIndex = endIndex;
        }
    }
}

