/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Properties;
import org.citrusframework.CitrusSettings;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.util.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyUtils {
    private static final char PROPERTY_MARKER = '@';
    public static final String BEAN_REF_PREFIX = "#bean:";
    public static final String CITRUS_COMPONENT_ENV_PREFIX = "CITRUS_COMPONENT_";
    public static final String CITRUS_ENDPOINT_ENV_PREFIX = "CITRUS_ENDPOINT_";
    public static final String CITRUS_ENDPOINT_CONFIG_ENV_PREFIX = "CITRUS_ENDPOINT_CONFIG_";
    public static final String CITRUS_COMPONENT_PROPERTY_PREFIX = "citrus.component.";
    public static final String CITRUS_ENDPOINT_PROPERTY_PREFIX = "citrus.endpoint.";
    private static final Logger logger = LoggerFactory.getLogger(PropertyUtils.class);

    private PropertyUtils() {
    }

    public static String replacePropertiesInString(String line, Resource propertyResource) {
        Properties properties = new Properties();
        try {
            properties.load(propertyResource.getInputStream());
        }
        catch (IOException e) {
            return line;
        }
        return PropertyUtils.replacePropertiesInString(line, properties);
    }

    public static String replacePropertiesInString(String line, Properties properties) {
        int searchIndex;
        StringBuilder newStr = new StringBuilder();
        boolean isVarComplete = false;
        StringBuilder propertyName = new StringBuilder();
        int startIndex = 0;
        while ((searchIndex = line.indexOf(64, startIndex)) != -1) {
            int curIndex;
            if (searchIndex != 0 && line.charAt(searchIndex - 1) == '\\') {
                newStr.append(line, startIndex, searchIndex - 1);
                newStr.append('@');
                startIndex = searchIndex + 1;
                continue;
            }
            for (curIndex = searchIndex + 1; curIndex < line.length() && !isVarComplete; ++curIndex) {
                if (line.charAt(curIndex) == '@' || curIndex + 1 == line.length()) {
                    isVarComplete = true;
                }
                if (isVarComplete) continue;
                propertyName.append(line.charAt(curIndex));
            }
            if (!properties.containsKey(propertyName.toString())) {
                throw new CitrusRuntimeException("No such property '@" + propertyName + "@'");
            }
            newStr.append(line, startIndex, searchIndex);
            newStr.append(properties.getProperty(propertyName.toString(), ""));
            startIndex = curIndex;
            propertyName = new StringBuilder();
            isVarComplete = false;
        }
        newStr.append(line.substring(startIndex));
        return newStr.toString();
    }

    public static void configure(String name, Object component, ReferenceResolver referenceResolver) {
        if (component == null || name == null && CitrusSettings.isEnvVarPropertyBindingEnabled()) {
            return;
        }
        if (System.getenv().keySet().stream().noneMatch(PropertyUtils::isComponentEnvVarSetting) && System.getProperties().keySet().stream().map(Object::toString).noneMatch(PropertyUtils::isComponentSystemPropertySetting)) {
            return;
        }
        try {
            if (CitrusSettings.isComponentPropertyBindingEnabled()) {
                PropertyUtils.bindProperties(CITRUS_COMPONENT_ENV_PREFIX, name, component, referenceResolver);
            }
            if (CitrusSettings.isEndpointPropertyBindingEnabled() && component instanceof Endpoint) {
                Endpoint endpoint = (Endpoint)component;
                PropertyUtils.bindProperties(CITRUS_ENDPOINT_ENV_PREFIX, name, endpoint, referenceResolver);
                PropertyUtils.bindProperties(CITRUS_ENDPOINT_CONFIG_ENV_PREFIX, name, endpoint.getEndpointConfiguration(), referenceResolver);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to configure envVar properties on component '{}': {}", (Object)name, (Object)e.getMessage());
            throw e;
        }
    }

    private static void bindProperties(String prefix, String name, Object component, ReferenceResolver referenceResolver) {
        if (component == null) {
            return;
        }
        if (System.getenv().keySet().stream().noneMatch(key -> PropertyUtils.isComponentEnvVarSetting(key, prefix, name)) && System.getProperties().keySet().stream().map(Object::toString).noneMatch(key -> PropertyUtils.isComponentSystemPropertySetting(key, prefix, name))) {
            return;
        }
        ReflectionHelper.doWithMethods(component.getClass(), method -> {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) return;
            String propertyName = method.getName().substring(3);
            String envName = "%s%s_%s".formatted(prefix, name, propertyName).toUpperCase(Locale.US);
            String sysPropName = "%s%s.%s%s".formatted(prefix.toLowerCase(Locale.US), name, propertyName.substring(0, 1).toLowerCase(Locale.US), propertyName.substring(1)).replaceAll("_", ".");
            String value = CitrusSettings.getPropertyEnvOrDefault((String)sysPropName, (String)envName, null);
            if (value == null) {
                envName = "%s%s%s".formatted(prefix, name.replaceAll("([A-Z])", "_$1"), propertyName.replaceAll("([A-Z])", "_$1")).toUpperCase(Locale.US);
                sysPropName = "%s%s.%s%s".formatted(prefix.toLowerCase(Locale.US), name, propertyName.substring(0, 1).toLowerCase(Locale.US), propertyName.substring(1).replaceAll("([A-Z])", "-$1").toLowerCase(Locale.US)).replaceAll("_", ".");
                value = CitrusSettings.getPropertyEnvOrDefault((String)sysPropName, (String)envName, null);
            }
            if (value == null) {
                return;
            }
            if (value.startsWith(BEAN_REF_PREFIX)) {
                if (!referenceResolver.isResolvable(value.substring(BEAN_REF_PREFIX.length()))) throw new CitrusRuntimeException("Failed to resolve property bean reference '%s' - no such bean in registry".formatted(value));
                ReflectionHelper.invokeMethod((Method)method, (Object)component, (Object[])new Object[]{TypeConverter.lookupDefault().convertIfNecessary(referenceResolver.resolve(value.substring(BEAN_REF_PREFIX.length())), method.getParameterTypes()[0])});
                return;
            } else {
                ReflectionHelper.invokeMethod((Method)method, (Object)component, (Object[])new Object[]{TypeConverter.lookupDefault().convertIfNecessary((Object)value, method.getParameterTypes()[0])});
            }
        });
    }

    private static boolean isComponentSystemPropertySetting(String key) {
        return key.startsWith(CITRUS_COMPONENT_PROPERTY_PREFIX) || key.startsWith(CITRUS_ENDPOINT_PROPERTY_PREFIX);
    }

    private static boolean isComponentEnvVarSetting(String key) {
        return key.startsWith(CITRUS_COMPONENT_ENV_PREFIX) || key.startsWith(CITRUS_ENDPOINT_ENV_PREFIX);
    }

    private static boolean isComponentSystemPropertySetting(String key, String prefix, String name) {
        return key.startsWith("%s%s".formatted(prefix.toLowerCase(Locale.US), name).replaceAll("_", "."));
    }

    private static boolean isComponentEnvVarSetting(String key, String prefix, String name) {
        return key.startsWith("%s%s".formatted(prefix, name)) || key.startsWith("%s%s".formatted(prefix, name.replaceAll("([A-Z])", "_$1")));
    }
}

