/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.StringValidationMatcher;

public class StringLengthValidationMatcher
implements StringValidationMatcher {
    @Override
    public void validate(String fieldName, String value, String controlValue, TestContext context) throws ValidationException {
        try {
            int control = Integer.parseInt(controlValue.strip());
            if (value.length() != control) {
                throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received value '" + value + "' should match string length '" + control + "'.");
            }
        }
        catch (NumberFormatException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Invalid matcher argument '" + controlValue + "'. Must be a number");
        }
    }
}

