/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ControlExpressionParser;
import org.citrusframework.validation.matcher.ParameterizedValidationMatcher;
import org.citrusframework.yaml.SchemaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeekdayValidationMatcher
implements ParameterizedValidationMatcher<Parameters>,
ControlExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(WeekdayValidationMatcher.class);

    public void validate(String fieldName, String value, Parameters controlParameters, TestContext context) throws ValidationException {
        SimpleDateFormat dateFormat;
        Weekday weekday = controlParameters.getWeekday();
        try {
            dateFormat = new SimpleDateFormat(controlParameters.getDateFormat());
        }
        catch (PatternSyntaxException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "' . Found invalid date format", (Throwable)e);
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(dateFormat.parse(value));
            if (cal.get(7) != weekday.getConstantValue()) {
                throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received invalid week day '" + value + "', expected date to be a '" + weekday + "'");
            }
            logger.debug("Weekday validation matcher successful - All values OK");
        }
        catch (ParseException e) {
            throw new ValidationException(this.getClass().getSimpleName() + " failed for field '" + fieldName + "'. Received invalid date format for value '" + value + "', expected date format is '" + controlParameters.getDateFormat() + "'", (Throwable)e);
        }
    }

    public List<String> extractControlValues(String controlExpression, Character delimiter) {
        ArrayList<String> parameters = new ArrayList<String>();
        if (controlExpression.contains("(")) {
            parameters.add(controlExpression.substring(0, controlExpression.indexOf("('")));
            parameters.add(controlExpression.substring(controlExpression.indexOf("('") + 2, controlExpression.length() - 2));
        } else {
            parameters.add(controlExpression);
        }
        return parameters;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedValidationMatcher.ControlParameters {
        private Weekday weekday;
        private String dateFormat = "dd.MM.yyyy";

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Missing validation matcher parameter - weekday is required");
            }
            this.setWeekday(Weekday.valueOf(parameterList.get(0).toUpperCase()));
            if (parameterList.size() > 1) {
                this.setDateFormat(parameterList.get(1));
            }
        }

        public Weekday getWeekday() {
            return this.weekday;
        }

        @SchemaProperty(required=true, description="The expected weekday.")
        public void setWeekday(Weekday weekday) {
            this.weekday = weekday;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        @SchemaProperty(description="The date format string.", defaultValue="dd.MM.yyyy")
        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }
    }

    public static enum Weekday {
        MONDAY(2),
        TUESDAY(3),
        WEDNESDAY(4),
        THURSDAY(5),
        FRIDAY(6),
        SATURDAY(7),
        SUNDAY(1);

        private final int constantValue;

        private Weekday(int constant) {
            this.constantValue = constant;
        }

        public int getConstantValue() {
            return this.constantValue;
        }
    }
}

