/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.actions;

import java.util.Optional;
import org.citrusframework.AbstractTestActionBuilder;
import org.citrusframework.TestAction;
import org.citrusframework.TestActor;
import org.citrusframework.TestActorAware;
import org.citrusframework.common.Described;
import org.citrusframework.common.Named;
import org.citrusframework.context.TestContext;

public abstract class AbstractTestAction
implements TestAction,
Named,
Described,
TestActorAware {
    protected String description;
    private String name = this.getClass().getSimpleName();
    private TestActor actor;

    protected AbstractTestAction() {
    }

    public AbstractTestAction(String name, AbstractTestActionBuilder<?, ?> builder) {
        this.name = Optional.ofNullable(builder.getName()).orElse(name);
        this.description = builder.getDescription();
        this.actor = builder.getActor();
    }

    public void execute(TestContext context) {
        if (!this.isDisabled(context)) {
            this.doExecute(context);
        }
    }

    public boolean isDisabled(TestContext context) {
        if (this.actor != null) {
            return this.actor.isDisabled();
        }
        return false;
    }

    public abstract void doExecute(TestContext var1);

    public String getDescription() {
        return this.description;
    }

    public AbstractTestAction setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestActor getActor() {
        return this.actor;
    }

    public AbstractTestAction setActor(TestActor actor) {
        this.actor = actor;
        return this;
    }
}

