/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class EncodeBase64Function
implements ParameterizedFunction<Parameters> {
    public String execute(Parameters params, TestContext context) {
        try {
            return Base64.encodeBase64String((byte[])params.getValue().getBytes(params.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException("Unsupported character encoding", (Throwable)e);
        }
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String value;
        private String charset = "UTF-8";

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Function parameters must not be empty");
            }
            this.setValue(parameterList.get(0));
            if (parameterList.size() > 1) {
                this.setCharset(parameterList.get(1));
            }
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true, description="The value to perform substring.")
        public void setValue(String value) {
            this.value = value;
        }

        public String getCharset() {
            return this.charset;
        }

        @SchemaProperty(description="Optional charset used to decode.", defaultValue="UTF-8")
        public void setCharset(String charset) {
            this.charset = charset;
        }
    }
}

