/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.functions.parameter.StringParameters;

public class RandomEnumValueFunction
implements ParameterizedFunction<StringParameters> {
    private final Random random = new Random(System.currentTimeMillis());
    private final List<String> values = new ArrayList<String>();

    public String execute(StringParameters params, TestContext context) {
        if (this.values.isEmpty()) {
            return this.randomValue(params.getValues());
        }
        if (params.getValues().isEmpty()) {
            return this.randomValue(this.values);
        }
        throw new InvalidFunctionUsageException("The enumeration values have already been set");
    }

    public StringParameters getParameters() {
        return new StringParameters().withAllowEmpty(!this.values.isEmpty());
    }

    protected String randomValue(List<String> values) {
        int idx = this.random.nextInt(values.size());
        return values.get(idx);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values.addAll(values);
    }
}

