/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import java.util.Random;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.yaml.SchemaProperty;

public class RandomNumberFunction
implements ParameterizedFunction<Parameters> {
    private static final Random generator = new Random(System.currentTimeMillis());

    public String execute(Parameters params, TestContext context) {
        if (params.getLength() < 1) {
            throw new InvalidFunctionUsageException("Invalid parameter definition. Number length must be a positive non-zero integer value");
        }
        return RandomNumberFunction.getRandomNumber(params);
    }

    public static String getRandomNumber(Parameters params) {
        return RandomNumberFunction.getRandomNumber(params.getLength(), params.isPaddingOn());
    }

    public static String getRandomNumber(int numberLength, boolean paddingOn) {
        if (numberLength < 1) {
            throw new InvalidFunctionUsageException("Number length must be a positive non-zero integer value - supplied " + numberLength);
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numberLength; ++i) {
            buffer.append(generator.nextInt(10));
        }
        return RandomNumberFunction.checkLeadingZeros(buffer.toString(), paddingOn);
    }

    public static String checkLeadingZeros(String generated, boolean paddingOn) {
        if (paddingOn) {
            return RandomNumberFunction.replaceLeadingZero(generated);
        }
        return RandomNumberFunction.removeLeadingZeros(generated);
    }

    private static String removeLeadingZeros(String generated) {
        StringBuilder builder = new StringBuilder();
        boolean leading = true;
        for (int i = 0; i < generated.length(); ++i) {
            if (generated.charAt(i) == '0' && leading) continue;
            leading = false;
            builder.append(generated.charAt(i));
        }
        if (builder.isEmpty()) {
            builder.append('0');
        }
        return builder.toString();
    }

    private static String replaceLeadingZero(String generated) {
        if (generated.charAt(0) == '0') {
            int replacement = 0;
            while (replacement == 0) {
                replacement = generator.nextInt(10);
            }
            return replacement + generated.substring(1);
        }
        return generated;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private int length;
        private boolean paddingOn = true;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.isEmpty()) {
                throw new InvalidFunctionUsageException("Function parameters must not be empty");
            }
            if (parameterList.size() > 2) {
                throw new InvalidFunctionUsageException("Too many parameters for function");
            }
            this.setLength(Integer.parseInt(parameterList.get(0)));
            if (parameterList.size() > 1) {
                this.setPaddingOn(Boolean.parseBoolean(parameterList.get(1)));
            }
        }

        public int getLength() {
            return this.length;
        }

        @SchemaProperty(required=true, description="Defines the length of the generated number.")
        public void setLength(int length) {
            this.length = length;
        }

        public boolean isPaddingOn() {
            return this.paddingOn;
        }

        @SchemaProperty(description="When enabled the generated number is filled with zero numbers to always get the given length.")
        public void setPaddingOn(boolean paddingOn) {
            this.paddingOn = paddingOn;
        }
    }
}

