/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.functions.core;

import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.ParameterizedFunction;
import org.citrusframework.util.StringUtils;
import org.citrusframework.yaml.SchemaProperty;

public class SubstringAfterFunction
implements ParameterizedFunction<Parameters> {
    public String execute(Parameters param, TestContext context) {
        String resultString = param.getValue();
        if (StringUtils.hasText(param.getSearchString())) {
            String searchString = param.getSearchString();
            resultString = resultString.substring(resultString.indexOf(searchString) + searchString.length());
        }
        return resultString;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedFunction.FunctionParameters {
        private String value;
        private String searchString;

        public void configure(List<String> parameterList, TestContext context) {
            if (parameterList == null || parameterList.size() < 2) {
                throw new InvalidFunctionUsageException("Function parameters not set correctly");
            }
            this.setValue(parameterList.get(0));
            if (parameterList.size() > 1) {
                this.setSearchString(parameterList.get(1));
            }
        }

        public String getValue() {
            return this.value;
        }

        @SchemaProperty(required=true, description="The value to perform substring.")
        public void setValue(String value) {
            this.value = value;
        }

        public String getSearchString() {
            return this.searchString;
        }

        @SchemaProperty(required=true, description="Search string used to substring after the occurrence.")
        public void setSearchString(String searchString) {
            this.searchString = searchString;
        }
    }
}

