/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.report;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionResult;
import org.citrusframework.TestCase;
import org.citrusframework.TestResult;
import org.citrusframework.common.ShutdownPhase;
import org.citrusframework.container.AbstractIteratingActionContainer;
import org.citrusframework.container.TestActionContainer;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.JsonNodeStringBuilder;
import org.citrusframework.json.JsonStringBuilder;
import org.citrusframework.message.MessageAwareTestAction;
import org.citrusframework.message.MessagePayloadUtils;
import org.citrusframework.report.AbstractTestReporter;
import org.citrusframework.report.TestActionListener;
import org.citrusframework.report.TestFlowReporterSettings;
import org.citrusframework.report.TestListener;
import org.citrusframework.report.TestResults;
import org.citrusframework.yaml.YamlNodeStringBuilder;
import org.citrusframework.yaml.YamlStringBuilder;

public class TestFlowReporter
extends AbstractTestReporter
implements TestListener,
TestActionListener,
ShutdownPhase {
    private final TestFlowReport flowReport = new TestFlowReport();
    private final boolean enabled = TestFlowReporterSettings.isReportEnabled();

    @Override
    protected void generate(TestResults testResults) {
        testResults.doWithResults(result -> {
            if (this.flowReport.entries.containsKey(result.getTestName())) {
                this.flowReport.entries.get(result.getTestName()).setResult(result);
            }
        });
        if (this.enabled) {
            File targetDirectory = new File(this.getReportDirectory());
            if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
                throw new CitrusRuntimeException("Unable to create report output directory: " + this.getReportDirectory());
            }
            this.flowReport.getEntries().forEach(reportEntry -> {
                if (TestFlowReporterSettings.isJsonReport()) {
                    this.writeTestFlowReport(targetDirectory, "%s-flow.json".formatted(reportEntry.getName()), MessagePayloadUtils.prettyPrintJson((String)reportEntry.toJson()));
                }
                if (TestFlowReporterSettings.isYamlReport()) {
                    this.writeTestFlowReport(targetDirectory, "%s-flow.yaml".formatted(reportEntry.getName()), reportEntry.toYaml());
                }
            });
        }
    }

    private void writeTestFlowReport(File targetDirectory, String fileName, String content) {
        try (FileWriter fileWriter = new FileWriter(new File(targetDirectory, fileName));){
            ((Writer)fileWriter).append(content);
            ((Writer)fileWriter).flush();
            this.logger.info("Generated test report: {}{}{}", new Object[]{targetDirectory, File.separator, fileName});
        }
        catch (IOException e) {
            this.logger.error("Failed to create test report", (Throwable)e);
        }
    }

    public void onTestActionStart(TestCase test, TestAction testAction) {
    }

    public void onTestActionFinish(TestCase test, TestAction testAction) {
        String actionPath = TestFlowReporter.getActionPath((TestActionContainer)test, testAction);
        TestActionResult tar = new TestActionResult(testAction.getName(), actionPath);
        if (testAction instanceof MessageAwareTestAction) {
            MessageAwareTestAction messageAware = (MessageAwareTestAction)testAction;
            messageAware.getMessage().ifPresent(arg_0 -> ((TestActionResult)tar).setMessage(arg_0));
        }
        ReportEntry reportEntry = this.flowReport.getOrCreateNew(test.getName());
        reportEntry.addAction(tar);
        if (testAction instanceof TestActionContainer) {
            TestActionContainer actionContainer = (TestActionContainer)testAction;
            this.addNestedTestActions(actionPath, actionContainer, tar);
        }
    }

    public void onTestActionFailed(TestCase test, TestAction testAction, Throwable cause) {
        String actionPath = TestFlowReporter.getActionPath((TestActionContainer)test, testAction);
        TestActionResult tar = new TestActionResult(testAction.getName(), actionPath);
        if (testAction instanceof MessageAwareTestAction) {
            MessageAwareTestAction messageAware = (MessageAwareTestAction)testAction;
            messageAware.getMessage().ifPresent(arg_0 -> ((TestActionResult)tar).setMessage(arg_0));
        }
        ReportEntry reportEntry = this.flowReport.getOrCreateNew(test.getName());
        reportEntry.addAction(tar);
        tar.setError(Optional.ofNullable(cause.getMessage()).orElse(""));
        if (testAction instanceof TestActionContainer) {
            TestActionContainer actionContainer = (TestActionContainer)testAction;
            this.addNestedTestActions(actionPath, actionContainer, tar);
        }
    }

    private void addNestedTestActions(String actionPath, TestActionContainer container, TestActionResult tar) {
        if (container instanceof AbstractIteratingActionContainer) {
            AbstractIteratingActionContainer iteratingActionContainer = (AbstractIteratingActionContainer)container;
            int iterations = iteratingActionContainer.getIterations();
            int actionsSize = iteratingActionContainer.getActions().size();
            for (int iteration = 0; iteration < iterations; ++iteration) {
                TestActionResult iterationResult = new TestActionResult(String.valueOf(iteration), actionPath);
                for (int i = iteration * actionsSize; i < container.getExecutedActions().size() && i < (iteration + 1) * actionsSize; ++i) {
                    TestAction action = (TestAction)container.getExecutedActions().get(i);
                    String nestedActionPath = iteration == 0 ? actionPath + "." + TestFlowReporter.getActionPath(container, action) : actionPath + "." + TestFlowReporter.getActionPath(container, action, iteration * actionsSize);
                    TestActionResult nested = new TestActionResult(action.getName(), nestedActionPath);
                    if (action instanceof MessageAwareTestAction) {
                        MessageAwareTestAction messageAware = (MessageAwareTestAction)action;
                        messageAware.getMessage().ifPresent(arg_0 -> ((TestActionResult)nested).setMessage(arg_0));
                    }
                    iterationResult.addAction(nested);
                    if (!(action instanceof TestActionContainer)) continue;
                    TestActionContainer actionContainer = (TestActionContainer)action;
                    this.addNestedTestActions(nestedActionPath, actionContainer, nested);
                }
                tar.addIteration(iterationResult);
            }
        } else {
            for (int i = 0; i < container.getExecutedActions().size(); ++i) {
                TestAction action = (TestAction)container.getExecutedActions().get(i);
                TestActionResult nested = new TestActionResult(action.getName(), actionPath + "." + TestFlowReporter.getActionPath(container, action));
                if (action instanceof MessageAwareTestAction) {
                    MessageAwareTestAction messageAware = (MessageAwareTestAction)action;
                    messageAware.getMessage().ifPresent(arg_0 -> ((TestActionResult)nested).setMessage(arg_0));
                }
                tar.addAction(nested);
                if (!(action instanceof TestActionContainer)) continue;
                TestActionContainer actionContainer = (TestActionContainer)action;
                this.addNestedTestActions(actionPath + "." + TestFlowReporter.getActionPath(container, action), actionContainer, nested);
            }
        }
    }

    public void onTestActionSkipped(TestCase test, TestAction testAction) {
    }

    private static String getActionPath(TestActionContainer container, TestAction testAction) {
        return "actions.%d.%s".formatted(container.getActionIndex(testAction), testAction.getName());
    }

    private static String getActionPath(TestActionContainer container, TestAction testAction, int iterationIndex) {
        return "actions.%d.%s".formatted(container.getActionIndex(testAction) % iterationIndex, testAction.getName());
    }

    public void onTestStart(TestCase test) {
        if (this.flowReport.get(test.getName()).isPresent()) {
            this.flowReport.reset(test.getName());
        }
    }

    public void onTestSuccess(TestCase test) {
        if (test.getTestResult() != null) {
            this.flowReport.getOrCreateNew(test.getName()).setResult(test.getTestResult());
        }
    }

    public void onTestFailure(TestCase test, Throwable cause) {
        if (test.getTestResult() != null) {
            this.flowReport.getOrCreateNew(test.getName()).setResult(test.getTestResult());
        }
    }

    public void onTestSkipped(TestCase test) {
    }

    public String getJsonReport() {
        return MessagePayloadUtils.prettyPrintJson((String)this.flowReport.toJson());
    }

    public String getYamlReport() {
        return this.flowReport.toYaml();
    }

    public void destroy() {
        this.clear();
    }

    public void clear() {
        this.flowReport.clear();
    }

    public static class TestFlowReport {
        private final Map<String, ReportEntry> entries = new ConcurrentHashMap<String, ReportEntry>();

        public void add(String name, ReportEntry entry) {
            this.entries.put(name, entry);
        }

        public Optional<ReportEntry> get(String name) {
            return Optional.ofNullable(this.entries.get(name));
        }

        public ReportEntry getOrCreateNew(String name) {
            if (!this.entries.containsKey(name)) {
                this.entries.put(name, new ReportEntry(name));
            }
            return this.entries.get(name);
        }

        public void reset(String name) {
            this.entries.put(name, new ReportEntry(name));
        }

        public List<ReportEntry> getEntries() {
            return new ArrayList<ReportEntry>(this.entries.values());
        }

        public String toJson() {
            JsonNodeStringBuilder builder = new JsonStringBuilder().withArray();
            this.entries.values().stream().map(ReportEntry::toJson).forEach(arg_0 -> ((JsonNodeStringBuilder)builder).append(arg_0));
            return builder.closeArray().toString();
        }

        public String toYaml() {
            YamlNodeStringBuilder builder = new YamlStringBuilder(2).withArray();
            this.entries.values().stream().map(ReportEntry::toYaml).forEach(arg_0 -> ((YamlNodeStringBuilder)builder).append(arg_0));
            return builder.closeArray().toString();
        }

        public void clear() {
            this.entries.clear();
        }
    }

    public static class ReportEntry {
        private final String name;
        private TestResult result;
        private final List<TestActionResult> actions = new ArrayList<TestActionResult>();

        public ReportEntry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public TestResult getResult() {
            return this.result;
        }

        public void setResult(TestResult result) {
            this.result = result;
        }

        public List<TestActionResult> getActions() {
            return this.actions;
        }

        public void addAction(TestActionResult action) {
            this.actions.add(action);
        }

        public String toJson() {
            return new JsonStringBuilder().withObject().withProperty("name", this.name).withProperty("result").append(Optional.ofNullable(this.result).map(TestResult::toJson).orElse("{}")).withProperty("actions").withArray().append(this.actions.stream().map(TestActionResult::toJson).collect(Collectors.joining(","))).closeArray().closeObject().toString();
        }

        public String toYaml() {
            return new YamlStringBuilder().withProperty("name", this.name).withObject("result").append(Optional.ofNullable(this.result).map(TestResult::toYaml).orElse("{}")).closeObject().withObject("actions").withArray().append(this.actions.stream().map(TestActionResult::toYaml).toList()).closeArray().closeObject().toString();
        }
    }
}

