/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.repository;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.Named;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public abstract class BaseRepository
implements Named,
InitializingPhase {
    private String name;
    private List<String> locations = new ArrayList<String>();

    protected BaseRepository(String name) {
        this.name = name;
    }

    public void initialize() {
        try {
            ClasspathResourceResolver resourceResolver = new ClasspathResourceResolver();
            for (String location : this.locations) {
                Set findings;
                Resource found = Resources.create((String)location);
                if (found.exists()) {
                    this.addRepository(found);
                    continue;
                }
                if (StringUtils.hasText(FileUtils.getFileExtension(location))) {
                    String fileNamePattern = FileUtils.getFileName(location).replace(".", "\\.").replace("*", ".*");
                    String basePath = FileUtils.getBasePath(location);
                    findings = resourceResolver.getResources(basePath, fileNamePattern);
                } else {
                    findings = resourceResolver.getResources(location);
                }
                for (Path resource : findings) {
                    this.addRepository(Resources.fromClasspath((String)resource.toString()));
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to initialize repository", (Throwable)e);
        }
    }

    protected abstract void addRepository(Resource var1);

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

