/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.util.Optional;
import org.citrusframework.message.Message;
import org.citrusframework.util.IsJsonPredicate;
import org.citrusframework.util.IsXmlPredicate;
import org.citrusframework.util.IsYamlPredicate;

public class MessageUtils {
    private MessageUtils() {
    }

    public static boolean hasXmlPayload(Message message) {
        if (!(message.getPayload() instanceof String)) {
            return false;
        }
        return Optional.ofNullable((String)message.getPayload(String.class)).map(String::trim).map(payload -> IsXmlPredicate.getInstance().test(payload)).orElse(true);
    }

    public static boolean hasJsonPayload(Message message) {
        if (!(message.getPayload() instanceof String)) {
            return false;
        }
        return Optional.ofNullable((String)message.getPayload(String.class)).map(String::trim).map(payload -> IsJsonPredicate.getInstance().test(payload)).orElse(true);
    }

    public static boolean hasYamlPayload(Message message) {
        if (!(message.getPayload() instanceof String)) {
            return false;
        }
        return Optional.ofNullable((String)message.getPayload(String.class)).map(String::trim).map(payload -> IsYamlPredicate.getInstance().test(payload)).orElse(true);
    }
}

