/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.util;

import java.util.Locale;

public class StringUtils {
    public static final String URL_PATH_SEPARATOR = "/";

    private StringUtils() {
    }

    public static boolean hasText(String str) {
        return str != null && !str.isBlank();
    }

    public static boolean hasNoText(String str) {
        return !StringUtils.hasText(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String appendSegmentToUrlPath(String path, String segment) {
        if (path == null) {
            return segment;
        }
        if (StringUtils.isEmpty(segment)) {
            return path;
        }
        if (!((String)path).endsWith(URL_PATH_SEPARATOR)) {
            path = (String)path + URL_PATH_SEPARATOR;
        }
        if (segment.startsWith(URL_PATH_SEPARATOR)) {
            segment = segment.substring(1);
        }
        return (String)path + segment;
    }

    public static String quote(String text, boolean quote) {
        return quote ? "\"" + text + "\"" : text;
    }

    public static void trimTrailingComma(StringBuilder builder) {
        int length = builder.length();
        while (length > 0 && (builder.charAt(length - 1) == ',' || Character.isWhitespace(builder.charAt(length - 1)))) {
            char c = builder.charAt(length - 1);
            builder.deleteCharAt(length - 1);
            if (c == ',') {
                return;
            }
            length = builder.length();
        }
    }

    public static String convertFirstCharToUpperCase(String input) {
        if (input != null && !input.isEmpty()) {
            String firstLetter = input.substring(0, 1).toUpperCase(Locale.ROOT);
            return input.length() == 1 ? firstLetter : firstLetter + input.substring(1);
        }
        return "";
    }

    public static String convertFirstCharToLowerCase(String input) {
        if (input != null && !input.isEmpty()) {
            String firstLetter = input.substring(0, 1).toLowerCase(Locale.ROOT);
            return input.length() == 1 ? firstLetter : firstLetter + input.substring(1);
        }
        return "";
    }

    public static String normalizeWhitespace(String text, boolean normalizeWhitespace, boolean normalizeLineEndingsToUnix) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (normalizeWhitespace) {
            StringBuilder result = new StringBuilder();
            boolean lastWasSpace = true;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!lastWasSpace) {
                        result.append(' ');
                    }
                    lastWasSpace = true;
                    continue;
                }
                result.append(c);
                lastWasSpace = false;
            }
            return result.toString().trim();
        }
        if (normalizeLineEndingsToUnix) {
            return text.replaceAll("\\r(\\n)?", "\n");
        }
        return text;
    }
}

