/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.validation.matcher.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.validation.matcher.ParameterizedValidationMatcher;
import org.citrusframework.yaml.SchemaProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateRangeValidationMatcher
implements ParameterizedValidationMatcher<Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(DateRangeValidationMatcher.class);

    public void validate(String fieldName, String value, Parameters params, TestContext context) throws ValidationException {
        logger.debug("Validating date range for date '{}' using control data: from: {} to: {} format: {}", new Object[]{value, params.getDateFrom(), params.getDateTo(), params.getDateFormat()});
        try {
            String dateFromParam = params.getDateFrom();
            String dateToParam = params.getDateTo();
            String dateFormat = params.getDateFormat();
            Calendar dateFrom = this.toCalender(dateFromParam, dateFormat);
            Calendar dateTo = this.toCalender(dateToParam, dateFormat);
            Calendar dateToValidate = this.toCalender(value, dateFormat);
            if (!this.checkInRange(dateFrom, dateTo, dateToValidate)) {
                String validationErr = String.format("%s failed for field '%s'. Date '%s' not in range: %s - %s", this.getClass().getSimpleName(), fieldName, value, dateFromParam, dateToParam);
                throw new ValidationException(validationErr);
            }
        }
        catch (Exception e) {
            if (e instanceof ValidationException) {
                throw e;
            }
            String validationErr = String.format("%s failed for field '%s'", this.getClass().getSimpleName(), fieldName);
            throw new ValidationException(validationErr, (Throwable)e);
        }
    }

    protected Calendar toCalender(String date, String datePattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(datePattern);
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(dateFormat.parse(date));
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException(String.format("Error parsing date '%s' using pattern '%s'", date, datePattern), (Throwable)e);
        }
        return cal;
    }

    private boolean checkInRange(Calendar dateFrom, Calendar dateTo, Calendar dateToCheck) {
        return this.checkGreaterOrEqualTo(dateFrom, dateToCheck) && this.checkGreaterOrEqualTo(dateToCheck, dateTo);
    }

    private boolean checkGreaterOrEqualTo(Calendar referenceDate, Calendar dateToCheck) {
        return referenceDate.compareTo(dateToCheck) <= 0;
    }

    public Parameters getParameters() {
        return new Parameters();
    }

    public static class Parameters
    implements ParameterizedValidationMatcher.ControlParameters {
        private static final String FALLBACK_DATE_PATTERN = "yyyy-MM-dd";
        private String dateFrom;
        private String dateTo;
        private String dateFormat = "yyyy-MM-dd";

        public void configure(List<String> parameterList, TestContext context) {
            if (!parameterList.isEmpty()) {
                this.setDateFrom(parameterList.get(0));
            }
            if (parameterList.size() > 1) {
                this.setDateTo(parameterList.get(1));
            }
            if (parameterList.size() > 2) {
                this.setDateFormat(parameterList.get(2));
            }
        }

        public String getDateFrom() {
            return this.dateFrom;
        }

        @SchemaProperty(required=true, description="The expected data range start value.")
        public void setDateFrom(String dateFrom) {
            this.dateFrom = dateFrom;
        }

        public String getDateTo() {
            return this.dateTo;
        }

        @SchemaProperty(required=true, description="The expected data range end value.")
        public void setDateTo(String dateTo) {
            this.dateTo = dateTo;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        @SchemaProperty(description="The date format string.", defaultValue="yyyy-MM-dd")
        public void setDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
        }
    }
}

