/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.PropertyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.ValidationException;
import org.citrusframework.spi.Resource;
import org.citrusframework.xml.Marshaller;
import org.citrusframework.xml.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Jaxb2Marshaller
implements Marshaller,
Unmarshaller {
    private static final Logger logger = LoggerFactory.getLogger(Jaxb2Marshaller.class);
    private volatile JAXBContext jaxbContext;
    private final Schema schema;
    private final Class<?>[] classesToBeBound;
    private final String contextPath;
    private final Map<String, Object> marshallerProperties = new HashMap<String, Object>();

    public Jaxb2Marshaller() {
        this(new Class[0]);
    }

    public Jaxb2Marshaller(Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
        this.contextPath = null;
        this.schema = null;
    }

    public Jaxb2Marshaller(String ... contextPaths) {
        this.classesToBeBound = null;
        this.contextPath = String.join((CharSequence)":", contextPaths);
        this.schema = null;
    }

    public Jaxb2Marshaller(Resource schemaResource, Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
        this.contextPath = null;
        this.schema = this.loadSchema(schemaResource);
    }

    public Jaxb2Marshaller(Resource schemaResource, String ... contextPaths) {
        this.classesToBeBound = null;
        this.contextPath = String.join((CharSequence)":", contextPaths);
        this.schema = this.loadSchema(schemaResource);
    }

    public Jaxb2Marshaller(Resource[] schemaResources, Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
        this.contextPath = null;
        this.schema = this.loadSchema(schemaResources);
    }

    public Jaxb2Marshaller(Resource[] schemaResources, String ... contextPaths) {
        this.classesToBeBound = null;
        this.contextPath = String.join((CharSequence)":", contextPaths);
        this.schema = this.loadSchema(schemaResources);
    }

    public void marshal(Object graph, Result result) throws JAXBException {
        this.createMarshaller().marshal(graph, result);
    }

    public Object unmarshal(Source source) throws JAXBException {
        return this.createUnmarshaller().unmarshal(source);
    }

    private jakarta.xml.bind.Marshaller createMarshaller() throws JAXBException {
        jakarta.xml.bind.Marshaller marshaller = this.getOrCreateContext().createMarshaller();
        if (this.schema != null) {
            marshaller.setSchema(this.schema);
        }
        this.marshallerProperties.forEach((k, v) -> {
            try {
                marshaller.setProperty(k, v);
            }
            catch (PropertyException e) {
                logger.warn("Unable to set marshaller property {}={}", k, v);
            }
        });
        return marshaller;
    }

    private jakarta.xml.bind.Unmarshaller createUnmarshaller() throws JAXBException {
        jakarta.xml.bind.Unmarshaller unmarshaller = this.getOrCreateContext().createUnmarshaller();
        if (this.schema != null) {
            unmarshaller.setSchema(this.schema);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getOrCreateContext() throws JAXBException {
        if (this.jaxbContext == null) {
            Jaxb2Marshaller jaxb2Marshaller = this;
            synchronized (jaxb2Marshaller) {
                logger.debug("Creating JAXBContext with bound classes {}", (Object)Arrays.toString(this.classesToBeBound));
                this.jaxbContext = this.classesToBeBound != null ? JAXBContext.newInstance((Class[])this.classesToBeBound) : (this.contextPath != null ? JAXBContext.newInstance((String)this.contextPath) : JAXBContext.newInstance((Class[])new Class[0]));
            }
        }
        return this.jaxbContext;
    }

    public void setProperty(String key, Object value) {
        this.marshallerProperties.put(key, value);
    }

    private Schema loadSchema(Resource ... schemas) {
        logger.debug("Using marshaller validation schemas '{}'", (Object)Stream.of(schemas).map(Object::toString).collect(Collectors.joining(",")));
        try {
            ArrayList<SAXSource> schemaSources = new ArrayList<SAXSource>();
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            for (Resource resource : schemas) {
                if (resource == null || !resource.exists()) {
                    throw new ValidationException(String.format("Resource does not exist: %s", Optional.ofNullable(resource).map(Resource::getLocation).orElse("null")));
                }
                InputSource inputSource = new InputSource(resource.getInputStream());
                inputSource.setSystemId(resource.getURI().toString());
                schemaSources.add(new SAXSource(xmlReader, inputSource));
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            return schemaFactory.newSchema(schemaSources.toArray(new Source[0]));
        }
        catch (SAXException e) {
            throw new CitrusRuntimeException("Failed to load schemas for marshaller", (Throwable)e);
        }
    }
}

