/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.actions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpServerRequestActionBuilder;
import org.citrusframework.http.actions.HttpServerResponseActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;
import org.citrusframework.util.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class HttpServerActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private ReferenceResolver referenceResolver;
    private Endpoint httpServer;
    private String httpServerUri;
    private TestActionBuilder<?> delegate;

    public HttpServerActionBuilder(Endpoint httpServer) {
        this.httpServer = httpServer;
    }

    public HttpServerActionBuilder(String httpServerUri) {
        this.httpServerUri = httpServerUri;
    }

    public HttpServerResponseActionBuilder respond() {
        return new HttpServerSendActionBuilder().response();
    }

    public HttpServerResponseActionBuilder respond(HttpStatus status) {
        return new HttpServerSendActionBuilder().response(status);
    }

    public HttpServerResponseActionBuilder.HttpMessageBuilderSupport respondOkJson(String json) {
        return ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)new HttpServerSendActionBuilder().response(HttpStatus.OK).message()).contentType("application/json").body(json);
    }

    public HttpServerResponseActionBuilder.HttpMessageBuilderSupport respondOkJson(Object json) {
        try {
            return this.respondOkJson(OBJECT_MAPPER.writeValueAsString(json));
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to write JSON body as string!", (Throwable)e);
        }
    }

    public HttpServerReceiveActionBuilder receive() {
        return new HttpServerReceiveActionBuilder();
    }

    public HttpServerSendActionBuilder send() {
        return new HttpServerSendActionBuilder();
    }

    private HttpServerRequestActionBuilder request(HttpMethod method, String path) {
        HttpServerRequestActionBuilder builder = new HttpServerRequestActionBuilder();
        if (this.httpServer != null) {
            builder.endpoint(this.httpServer);
        } else {
            builder.endpoint(this.httpServerUri);
        }
        builder.name("http:receive-request");
        builder.withReferenceResolver(this.referenceResolver);
        ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)builder.message()).method(method);
        if (StringUtils.hasText((String)path)) {
            builder.path(path);
        }
        this.delegate = builder;
        return builder;
    }

    public HttpServerActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }

    public class HttpServerSendActionBuilder {
        public HttpServerResponseActionBuilder response() {
            HttpServerResponseActionBuilder builder = new HttpServerResponseActionBuilder();
            if (HttpServerActionBuilder.this.httpServer != null) {
                builder.endpoint(HttpServerActionBuilder.this.httpServer);
            } else {
                builder.endpoint(HttpServerActionBuilder.this.httpServerUri);
            }
            builder.name("http:send-response");
            builder.withReferenceResolver(HttpServerActionBuilder.this.referenceResolver);
            HttpServerActionBuilder.this.delegate = builder;
            return builder;
        }

        public HttpServerResponseActionBuilder response(HttpStatus status) {
            HttpServerResponseActionBuilder builder = new HttpServerResponseActionBuilder();
            if (HttpServerActionBuilder.this.httpServer != null) {
                builder.endpoint(HttpServerActionBuilder.this.httpServer);
            } else {
                builder.endpoint(HttpServerActionBuilder.this.httpServerUri);
            }
            builder.name("http:send-response");
            builder.withReferenceResolver(HttpServerActionBuilder.this.referenceResolver);
            ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)builder.message()).status(status);
            HttpServerActionBuilder.this.delegate = builder;
            return builder;
        }
    }

    public class HttpServerReceiveActionBuilder {
        public HttpServerRequestActionBuilder get() {
            return HttpServerActionBuilder.this.request(HttpMethod.GET, null);
        }

        public HttpServerRequestActionBuilder get(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.GET, path);
        }

        public HttpServerRequestActionBuilder post() {
            return HttpServerActionBuilder.this.request(HttpMethod.POST, null);
        }

        public HttpServerRequestActionBuilder post(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.POST, path);
        }

        public HttpServerRequestActionBuilder put() {
            return HttpServerActionBuilder.this.request(HttpMethod.PUT, null);
        }

        public HttpServerRequestActionBuilder put(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.PUT, path);
        }

        public HttpServerRequestActionBuilder delete() {
            return HttpServerActionBuilder.this.request(HttpMethod.DELETE, null);
        }

        public HttpServerRequestActionBuilder delete(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.DELETE, path);
        }

        public HttpServerRequestActionBuilder head() {
            return HttpServerActionBuilder.this.request(HttpMethod.HEAD, null);
        }

        public HttpServerRequestActionBuilder head(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.HEAD, path);
        }

        public HttpServerRequestActionBuilder options() {
            return HttpServerActionBuilder.this.request(HttpMethod.OPTIONS, null);
        }

        public HttpServerRequestActionBuilder options(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.OPTIONS, path);
        }

        public HttpServerRequestActionBuilder trace() {
            return HttpServerActionBuilder.this.request(HttpMethod.TRACE, null);
        }

        public HttpServerRequestActionBuilder trace(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.TRACE, path);
        }

        public HttpServerRequestActionBuilder patch() {
            return HttpServerActionBuilder.this.request(HttpMethod.PATCH, null);
        }

        public HttpServerRequestActionBuilder patch(String path) {
            return HttpServerActionBuilder.this.request(HttpMethod.PATCH, path);
        }
    }
}

