/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.http.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.http.security.User;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.util.security.Credential;
import org.springframework.beans.factory.FactoryBean;

public class SecurityHandlerFactory
implements FactoryBean<SecurityHandler>,
InitializingPhase {
    private List<User> users = new ArrayList<User>();
    private String realm = "realm";
    private Map<String, Constraint> constraints = new HashMap<String, Constraint>();
    private LoginService loginService;
    private Authenticator authenticator = new BasicAuthenticator();

    public SecurityHandler getObject() throws Exception {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setAuthenticator(this.authenticator);
        securityHandler.setRealmName(this.realm);
        for (Map.Entry<String, Constraint> constraint : this.constraints.entrySet()) {
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint.getValue());
            constraintMapping.setPathSpec(constraint.getKey());
            securityHandler.addConstraintMapping(constraintMapping);
        }
        securityHandler.setLoginService(this.loginService);
        return securityHandler;
    }

    public void initialize() {
        if (this.loginService == null) {
            this.loginService = new SimpleLoginService();
            ((SimpleLoginService)this.loginService).setName(this.realm);
        }
    }

    public Class<?> getObjectType() {
        return SecurityHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<String, Constraint> constraints) {
        this.constraints = constraints;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public void setLoginService(LoginService loginService) {
        this.loginService = loginService;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    private class SimpleLoginService
    extends HashLoginService {
        private SimpleLoginService() {
        }

        protected void doStart() throws Exception {
            SimplePropertyUserStore userStore = new SimplePropertyUserStore();
            this.setUserStore((UserStore)userStore);
            userStore.start();
            super.doStart();
        }
    }

    private class SimplePropertyUserStore
    extends PropertyUserStore {
        private SimplePropertyUserStore() {
        }

        protected void loadUsers() {
            for (User user : SecurityHandlerFactory.this.users) {
                Credential credential = Credential.getCredential((String)user.getPassword());
                String[] roles = ArrayUtils.isNotEmpty((Object[])user.getRoles()) ? user.getRoles() : new String[]{};
                this.addUser(user.getName(), credential, roles);
            }
        }
    }
}

