/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.jbang.engine;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.TestSource;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.jbang.CitrusJBang;
import org.citrusframework.jbang.ProcessOutputListener;
import org.citrusframework.main.AbstractTestEngine;
import org.citrusframework.main.TestRunConfiguration;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;

public class JBangTestEngine
extends AbstractTestEngine {
    private Path workingDir;
    private ProcessOutputListener outputListener;

    public JBangTestEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        CitrusJBang citrus = new CitrusJBang().workingDir(Optional.ofNullable(this.getConfiguration().getWorkDir()).filter(StringUtils::isNotEmpty).map(FileUtils::getFileResource).map(Resource::getFile).map(File::toPath).orElse(this.workingDir));
        if (this.outputListener != null) {
            citrus.withOutputListener(this.outputListener);
        }
        if (this.getConfiguration().getTestSources().isEmpty()) {
            this.runTestPackages(citrus, this.getConfiguration());
        } else {
            this.runTestSources(citrus, this.getConfiguration());
        }
    }

    private void runTestPackages(CitrusJBang citrus, TestRunConfiguration configuration) {
        List<Object> packagesToRun = Optional.ofNullable(configuration.getPackages()).orElseGet(Collections::emptyList).stream().map(packageName -> packageName.replace(".", "/")).collect(Collectors.toList());
        if (packagesToRun.isEmpty()) {
            packagesToRun = Collections.singletonList("");
            logger.info("Running all tests in project");
        }
        for (String packageName2 : packagesToRun) {
            if (StringUtils.hasText((String)packageName2)) {
                logger.info(String.format("Running tests in directory %s", packageName2));
            } else {
                logger.info(String.format("Running tests in current working directory %s", Optional.ofNullable(this.workingDir).map(Path::toString).orElse(".")));
            }
            citrus.run(packageName2, Collections.emptyMap());
        }
    }

    private void runTestSources(CitrusJBang citrus, TestRunConfiguration configuration) {
        List<TestSource> directories = configuration.getTestSources().stream().filter(source -> "directory".equals(source.getType())).toList();
        for (TestSource directory : directories) {
            logger.info(String.format("Running tests in directory %s", directory.getName()));
            citrus.run(directory.getFilePath(), Collections.emptyMap());
        }
        List<TestSource> sources = configuration.getTestSources().stream().filter(source -> !"directory".equals(source.getType())).toList();
        for (TestSource source2 : sources) {
            try {
                logger.info(String.format("Running test source %s", source2.getName()));
                if (source2.getSourceFile() instanceof Resources.ByteArrayResource) {
                    Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    c.setContents(new StringSelection(FileUtils.readToString((Resource)source2.getSourceFile())), null);
                    String fileExt = Optional.of(FileUtils.getFileExtension((String)source2.getName())).filter(ext -> !ext.isEmpty()).orElse(".yaml");
                    citrus.run("clipboard" + fileExt, Collections.emptyMap());
                    continue;
                }
                if (StringUtils.hasText((String)source2.getFilePath())) {
                    citrus.run(source2.getFilePath(), Collections.emptyMap());
                    continue;
                }
                citrus.run(source2.getSourceFile().getLocation(), Collections.emptyMap());
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to run test source: %s".formatted(source2.getName()), (Throwable)e);
            }
        }
    }

    public JBangTestEngine withWorkingDir(Path workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public JBangTestEngine withOutputListener(ProcessOutputListener outputListener) {
        this.outputListener = outputListener;
        return this;
    }
}

