/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.kafka.embedded;

import java.util.Map;
import org.citrusframework.kafka.embedded.EmbeddedKafkaServer;

public class EmbeddedKafkaServerBuilder {
    private final EmbeddedKafkaServer kafkaServer;

    public EmbeddedKafkaServerBuilder() {
        this(new EmbeddedKafkaServer());
    }

    public EmbeddedKafkaServerBuilder(EmbeddedKafkaServer kafkaServer) {
        this.kafkaServer = kafkaServer;
    }

    public EmbeddedKafkaServerBuilder kafkaServerPort(int port) {
        this.kafkaServer.setKafkaServerPort(port);
        return this;
    }

    public EmbeddedKafkaServerBuilder zookeeperPort(int port) {
        this.kafkaServer.setZookeeperPort(port);
        return this;
    }

    public EmbeddedKafkaServerBuilder topics(String topics) {
        this.kafkaServer.setTopics(topics);
        return this;
    }

    public EmbeddedKafkaServerBuilder topics(String ... topics) {
        return this.topics(String.join((CharSequence)",", topics));
    }

    public EmbeddedKafkaServerBuilder partitions(int count) {
        this.kafkaServer.setPartitions(count);
        return this;
    }

    public EmbeddedKafkaServerBuilder brokerProperties(Map<String, String> properties) {
        this.kafkaServer.setBrokerProperties(properties);
        return this;
    }

    public EmbeddedKafkaServerBuilder logDirPath(String logDirPath) {
        this.kafkaServer.setLogDirPath(logDirPath);
        return this;
    }

    public EmbeddedKafkaServerBuilder autoDeleteLogs(boolean autoDelete) {
        this.kafkaServer.setAutoDeleteLogs(autoDelete);
        return this;
    }

    public EmbeddedKafkaServer build() {
        return this.kafkaServer;
    }
}

